<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require __DIR__ . '/vendor/PHPMailer/Exception.php';
require __DIR__ . '/vendor/PHPMailer/PHPMailer.php';
require __DIR__ . '/vendor/PHPMailer/SMTP.php';
require __DIR__ . '/vendor/recaptcha/autoload.php';
require __DIR__ . '/includes/fpdf/fpdf.php';
require __DIR__ . '/vendor/phpqrcode/phpqrcode/qrlib.php';

header("Content-Type: application/json");

require_once 'utility/tools.php';
require_once 'utility/constants.php';
require_once 'config/db_config.php';

date_default_timezone_set('Asia/Kuala_Lumpur');

// Capture the raw POST data
$rawPayload = file_get_contents("php://input");

// Decode the JSON payload
$payload = json_decode($rawPayload, true);
file_put_contents("webhook.log", json_encode($payload, JSON_PRETTY_PRINT) . "\n", FILE_APPEND);

if (!$payload) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

$tran_ref = null;

if(empty($payload['txnRefNum'])) {
    exit;
}

if($payload['prestoMrn'] != PRESTO_MRN_STAGING_WEBPAY) {
    exit;
}

if($payload['mid'] != PRESTO_STAGING_MID) {
    exit;
}

$tran_ref = $payload['txnRefNum'];

$select_sql = "SELECT * FROM wpcf_presto_reg_transaction WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."' AND status = 'pending' LIMIT 1";
$select_query = mysqli_query($con, $select_sql);

if (!$select_query) {
    errorResponse("Error description: " . mysqli_error($con));
}

$fetched_row = mysqli_fetch_assoc($select_query);

if($fetched_row) {
    $update_callback_sql = "UPDATE wpcf_presto_reg_transaction 
        SET payment_callback='".mysqli_real_escape_string($con, json_encode($payload))."'
        WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."'";

    $update_callback_query = mysqli_query($con, $update_callback_sql);

    if (!$update_callback_query) {
        errorResponse("Error description: " . mysqli_error($con));
    }

    if($payload['eventCode'] == "Authorised") {
        if($payload['success'] == true) {
            $update_status_sql = "UPDATE wpcf_presto_reg_transaction 
                SET `status` = 'success'
                WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."'";

            $update_status_query = mysqli_query($con, $update_status_sql);

            if (!$update_status_query) {
                errorResponse("Error description: " . mysqli_error($con));
            }
            
            $select_sql = "SELECT * FROM wpcf_presto_reg_transaction WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."'";
            $select_query = mysqli_query($con, $select_sql);
            $fetched_row = mysqli_fetch_assoc($select_query);
            
            $visaRequired = ($fetched_row['visaRequired'] ?? 'no') === 'yes';
            $passportNo = $fetched_row['passportNumber'] ?? '';
            $passportExpiry = $fetched_row['passportExpiry'] ?? '';
            $embassyLocation = $fetched_row['embassyLocation'] ?? '';
            $embassyName = $fetched_row['embassyName'] ?? '';
            $embassyAddress = $fetched_row['embassyAddress'] ?? '';

            // Process photo if exists in temp directory
            if (!empty($fetched_row['photo_url']) && strpos($fetched_row['photo_url'], 'photo/temp/') !== false) {
                $tempPath = __DIR__ . '/' . $fetched_row['photo_url'];
                $newPath = str_replace('photo/temp/', 'photo/success/', $fetched_row['photo_url']);
                $fullNewPath = __DIR__ . '/' . $newPath;
                
                // Create success directory if it doesn't exist
                $successDir = dirname($fullNewPath);
                if (!file_exists($successDir)) {
                    mkdir($successDir, 0777, true);
                }
                
                // Move the file from temp to success directory
                if (file_exists($tempPath) && is_readable($tempPath)) {
                    if (rename($tempPath, $fullNewPath)) {
                        // Update the photo_url in database to new location
                        $update_sql = "UPDATE wpcf_presto_reg_transaction SET photo_url = ? WHERE donate_ref = ?";
                        $photo_stmt = $con->prepare($update_sql);
                        $photo_stmt->bind_param("ss", $newPath, $tran_ref);
                        $photo_stmt->execute();
                    }
                }
            }

            // Fetch data from database
            $recipientName = $fetched_row['firstname'] . ' ' . $fetched_row['lastname'];
            $recipientEmail = $fetched_row['email'];
            $registrationCategory = $fetched_row['registrationType']; 
            $presentationType = $fetched_row['presentationType'] ?? '';
            $amountPaid = $fetched_row['amount'];
            $galaDinner = $fetched_row['galaDinner'] ?? 'No';
            $paymentMethod ='Presto';

            // Send confirmation email with PDF invoice
            $emailResult = sendRegistrationConfirmationEmail(
                $recipientEmail, 
                $recipientName, 
                $registrationCategory, 
                $presentationType, 
                $amountPaid, 
                $galaDinner, 
                $paymentMethod,
                $tran_ref
            );
            
            // Send visa invitation if required
            if ($visaRequired) {
                $visaEmailResult = sendVisaInvitationEmail(
                    $recipientEmail, 
                    $recipientName,
                    $passportNo,
                    $passportExpiry,
                    $embassyLocation,
                    $embassyName,
                    $embassyAddress,
                    $registrationCategory,
                    $presentationType,
                    $tran_ref
                );
                
                if (!$visaEmailResult) {
                    error_log("Failed to send visa invitation email for transaction: $tran_ref");
                    file_put_contents("email_errors.log", "Visa invitation failed for $tran_ref\n", FILE_APPEND);
                } else {
                    file_put_contents("email.log", "Visa invitation sent for $tran_ref\n", FILE_APPEND);
                }
            }
            
            file_put_contents("email.log", $emailResult . "\n", FILE_APPEND);
            successResponse();
        } else {
            $update_status_sql = "UPDATE wpcf_presto_reg_transaction 
                SET `status` = 'failed'
                WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."'";

            $update_status_query = mysqli_query($con, $update_status_sql);

            if (!$update_status_query) {
                errorResponse("Error description: " . mysqli_error($con));
            }

            errorResponse('failed');
        }
    } else {
        $update_status_sql = "UPDATE wpcf_presto_reg_transaction 
            SET `status` = 'failed'
            WHERE donate_ref = '".mysqli_real_escape_string($con, $tran_ref)."'";

        $update_status_query = mysqli_query($con, $update_status_sql);

        if (!$update_status_query) {
            errorResponse("Error description: " . mysqli_error($con));
        }

        errorResponse('failed');
    }
} else {
    exit;
}

function generateQRCode($data, $transactionRef) {
    $qrDir = __DIR__ . '/qrcodes';
    if (!file_exists($qrDir)) {
        if (!mkdir($qrDir, 0777, true)) {
            error_log("Failed to create QR directory: $qrDir");
            return false;
        }
    }
    
    $qrFilePath = $qrDir . '/qr_' . $transactionRef . '.png';
    
    // Generate QR code
    QRcode::png($data, $qrFilePath, QR_ECLEVEL_L, 5);
    
    return $qrFilePath;
}

function generateInvoicePDF($recipientName, $recipientEmail, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef) {
    // Prepare data for QR code
    $qrData = "ECO-CAMPUS CONFERENCE REGISTRATION\n";
    $qrData .= "Name: " . $recipientName . "\n";
    $qrData .= "Email: " . $recipientEmail . "\n";
    $qrData .= "Registration: " . $registrationCategory . "\n";
    $qrData .= "Transaction: " . $transactionRef . "\n";
    $qrData .= "Gala Dinner: " . $galaDinner . "\n";
    $qrData .= "Amount: MYR " . $amountPaid . "\n";
    $qrData .= "Event: Eco-Campus International Conference 2025\n";
    $qrData .= "Date: 18-20 September 2025\n";
    $qrData .= "Location: International Youth Center, Kuala Lumpur";
    
    // Generate QR code
    $qrFilePath = generateQRCode($qrData, $transactionRef);
    
    $pdf = new FPDF();
    $pdf->AddPage();
    
    // Logo positioning
    $logoPath = __DIR__ . '/images/headerlogo.png';
    if (file_exists($logoPath)) {
        $pdf->Image($logoPath, 10, 10, 50);
    }

    $headerImagePath = __DIR__ . '/images/GGAF.png';
    if (file_exists($headerImagePath)) {
        $pdf->Image($headerImagePath, 150, 10, 50);
    }

    // Conference title
    $pdf->SetFont('Arial','B',16);
    $pdf->SetY(40);
    $pdf->Cell(0,10,'Eco-Campus International Conference 2025',0,1,'C');

    // Address block
    $pdf->SetFont('Arial','',10);
    $pdf->SetY(50);
    $pdf->MultiCell(0, 5, 
        "International Youth Center, Kuala Lumpur, Malaysia\n".
        "18th to 20th September 2025",
        0, 'C');

    // Line separator
    $pdf->SetDrawColor(200, 200, 200);
    $pdf->Line(10, $pdf->GetY() + 5, 200, $pdf->GetY() + 5);
    $pdf->SetY($pdf->GetY() + 10);

    // Invoice details
    $label = 'Transaction Number:';
    $pdf->SetFont('Arial', 'B', 12); 
    $labelWidth = $pdf->GetStringWidth($label) + 2;
    $pdf->Cell($labelWidth, 10, $label);
    $pdf->Cell(0, 10, $transactionRef, 0, 1); 
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Payment Date:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,date('Y-m-d'),0,1);
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Name:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,$recipientName,0,1);
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Email:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,$recipientEmail,0,1);
    
    // Item table
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(100,10,'Description',1,0);
    $pdf->Cell(40, 10, iconv('UTF-8', 'Windows-1252', 'Amount MYR'), 1, 1);
    
    // Calculate prices
    $registrationPrice = ($registrationCategory == 'General') ? 501.30 : 250.65;
    $galaDinnerPrice = ($galaDinner == 'Yes') ? 150.39 : 0;
    $totalAmount = $registrationPrice + $galaDinnerPrice;

    // Registration row
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(100,10, ucfirst(strtolower($registrationCategory)) . ' Registration',1,0);
    $pdf->Cell(40,10, number_format($registrationPrice, 2),1,1,'R');

    // Gala Dinner row (if selected)
    if ($galaDinner == 'Yes') {
        $pdf->Cell(100,10, 'Gala Dinner',1,0);
        $pdf->Cell(40,10, number_format($galaDinnerPrice, 2),1,1,'R');
    }

    // Presentation Type (free, no cost)
    if (!empty($presentationType)) {
        $pdf->Cell(100,10, 'Presentation Type: ' . $presentationType,1,0);
        $pdf->Cell(40,10, '-',1,1,'R');
    }
    
    // Total row
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(100,10, 'Total',1,0);
    $pdf->Cell(40,10, number_format($totalAmount, 2),1,1,'R');
    $pdf->Ln(10);
    
    // Payment method
    $pdf->Cell(0,10,'Payment Method: ' . $paymentMethod,0,1);
    $pdf->Ln(5);
    
    // Add QR code to the PDF
    if (file_exists($qrFilePath)) {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'Your Conference Registration QR Code:', 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->Image($qrFilePath, ($pdf->GetPageWidth() - 40) / 2, $pdf->GetY(), 40);
        $pdf->Ln(40);
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 5, 'Please present this QR code at the registration desk to check in quickly.', 0, 'C');
    }
    
    // Footer
    $pdf->SetFont('Arial','I',10);
    $pdf->Cell(0,10,'THANK YOU FOR YOUR PAYMENT! ',0,1,'C');
    $pdf->Cell(0,10,'SEE YOU IN KUALA LUMPUR!!',0,1,'C');
    
    // Save PDF
    $pdfDir = __DIR__ . '/invoices';
    if (!file_exists($pdfDir)) {
        mkdir($pdfDir, 0777, true);
    }
    $pdfFilePath = $pdfDir . '/invoice_' . $transactionRef . '.pdf';
    $pdf->Output($pdfFilePath, 'F');
    
    // Clean up QR code file after PDF generation
    if (file_exists($qrFilePath)) {
        unlink($qrFilePath);
    }
    
    return ['pdf' => $pdfFilePath, 'qr' => $qrFilePath];
}

function generateVisaInvitationPDF($recipientName, $recipientEmail, $passportNumber, $passportExpiry, $embassyLocation, $participationType) {
    $pdf = new FPDF();
    $pdf->AddPage();
    
    // Set margins
    $pdf->SetTopMargin(30);
    $pdf->SetLeftMargin(20);
    $pdf->SetRightMargin(20); 
    $pdf->SetAutoPageBreak(false);

    // Add left logo
    $leftLogoPath = __DIR__ . '/images/GGAF-logo-2.png';
    if (file_exists($leftLogoPath)) {
        $pdf->Image($leftLogoPath, 20, 10, 20);  
    }
    
    // Add right logo
    $rightLogoPath = __DIR__ . '/images/Empowering Youth_PNG-04.png';
    if (file_exists($rightLogoPath)) {
        $pdf->Image($rightLogoPath, 140, 10, 60); 
    }

    // Position after logos
    $pdf->SetY(50);

    // Date
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, date('F j, Y'), 0, 1, 'L'); 
    $pdf->Ln(3);

    // To whom it may concern
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, 'To whom it may concern', 0, 1);
    $pdf->Ln(3);

    // Subject line
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, 'Subject: Invitation Letter for Visa Application - ' . $recipientName, 0, 1);
    $pdf->Ln(3);

    // Dear Sir/Madam
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(0, 6, 'Dear Sir/Madam,', 0, 1);
    $pdf->Ln(3);

    // Main content with highlighting key information
    $pdf->SetFont('Arial', '', 10);
    
    // First paragraph
    $pdf->Write(5, 'Green Growth Asia Foundation, the National Operator of the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Foundation for Environmental Education (FEE)');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' in Malaysia, is pleased to invite ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $recipientName);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', holder of passport number ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $passportNumber);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', expiring on ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $passportExpiry);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', from ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $embassyLocation);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', to participate as ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $participationType);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' at the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Eco-Campus International Conference 2025');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, '.');
    $pdf->Ln(8);
    
    // Second paragraph
    $pdf->Write(5, 'The conference will take place from ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, '18th to 20th September 2025');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' at the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'International Youth Centre');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' in Kuala Lumpur, Malaysia. We encourage participants to arrive a day in advance, and they may extend their stay at their discretion.');
    $pdf->Ln(8);
    
    // Third paragraph
    $pdf->Write(5, 'We kindly request your assistance in granting the necessary visa to allow ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $recipientName);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' to attend this conference. For further information, please contact ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Dr. Balamurugan Ratha Krishnan, CEO, at +6012-2166826');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' or ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'balamurugan.rk@greengrowthasia.org');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, '.');
    $pdf->Ln(8);
    
    // Thank you
    $pdf->Write(5, 'Thank you for your consideration.');
    $pdf->Ln(12);
    
    // Signature section
    $pdf->Cell(0, 5, 'Yours sincerely,', 0, 1);
    $pdf->Ln(5);
    
    // Add signature logo if available
    $signatureLogoPath = __DIR__ . '/images/Sign.png';
    if (file_exists($signatureLogoPath)) {
        $pdf->Image($signatureLogoPath, 20, $pdf->GetY(), 40);
        $pdf->Ln(20);
    } else {
        $pdf->Ln(15); 
    }
    
    // Signatory details
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(0, 5, 'on behalf of Green Growth Asia Foundation', 0, 1);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 5, 'Balamurugan Ratha Krishnan', 0, 1);
    $pdf->SetFont('Arial', 'I', 10);
    $pdf->Cell(0, 5, 'Chief Executive Officer', 0, 1);

    // Footer
    $pdf->SetY(-15);
    $pdf->SetFont('Arial', '', 8);
    $footerText = "GREEN GROWTH ASIA FOUNDATION (1271-0843) | ".
                 "HQ: No. 21-2, Jalan DR 1, Tarnan Delima, 75150 Bukit Baru, Meleika | ".
                 "Branch: A-02-10, Plaza Damas 3, Jalan Sri Harlamas 1, 50480 Kuala Lumpur";
    $pdf->MultiCell(0, 4, $footerText, 0, 'C');
    
    $contactText = "Tel: +606-230 0038 (HQ), +603-6211 2869 (Branch) | Website: www.greengrowthasia.org";
    $pdf->MultiCell(0, 4, $contactText, 0, 'C');
    
    // Save PDF
    $visaDir = __DIR__ . '/visa_letters';
    if (!file_exists($visaDir)) {
        mkdir($visaDir, 0777, true);
    }
    $pdfFilePath = $visaDir . '/visa_invitation_' . preg_replace('/[^a-zA-Z0-9]/', '_', $recipientName) . '.pdf';
    $pdf->Output($pdfFilePath, 'F');
    
    return $pdfFilePath;
}

function sendVisaInvitationEmail($recipientEmail, $recipientName, $passportNumber, $passportExpiry, $embassyLocation, $embassyName, $embassyAddress, $registrationCategory, $presentationType, $transactionRef) {
    $mail = new PHPMailer(true);
    $success = false;

    try {
        // Generate visa invitation letter
        $participationType = !empty($presentationType) ? "a Presenter ($presentationType)" : "an Attendee";
        $visaFilePath = generateVisaInvitationPDF($recipientName, $recipientEmail, $passportNumber, $passportExpiry, $embassyLocation, $participationType);
        
        if (!file_exists($visaFilePath)) {
            throw new Exception("Failed to generate visa invitation PDF");
        }

        // Generate invoice (reusing existing function)
        $invoiceFilePath = generateInvoicePDF(
            $recipientName, 
            $recipientEmail, 
            $registrationCategory, 
            $presentationType, 
            0, // Amount not needed for visa letter
            'No', // Gala dinner not needed
            '', // Payment method not needed
            $transactionRef
        );

        if (!file_exists($invoiceFilePath['pdf'])) {
            throw new Exception("Failed to generate invoice PDF");
        }

        // SMTP Configuration
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'erp-admin@greengrowthasia.org';
        $mail->Password = 'fxzisdzwgwyuhasz';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;
        $mail->SMTPDebug = 0; // Set to 2 for debugging
        $mail->Debugoutput = function($str, $level) {
            file_put_contents('smtp_debug.log', "$level: $str\n", FILE_APPEND);
        };

        $mail->setFrom('erp-admin@greengrowthasia.org', 'Eco-Campus International Conference 2025');
        $mail->addAddress($recipientEmail, $recipientName);
        $mail->addBCC('erp-admin@greengrowthasia.org', 'Admin Copy');
        $mail->Subject = "Visa Application Invitation Letter to Eco-Campus International Conference 2025";

        // Attachments
        $mail->addAttachment($visaFilePath, 'Visa_Invitation_Letter_'.$transactionRef.'.pdf');
        // $mail->addAttachment($invoiceFilePath['pdf'], 'Invoice_'.$transactionRef.'.pdf');

        // Email content
        $mail->isHTML(true);
        
        $mailBody = "
            <p>Dear $recipientName,</p>
            <p>Thank you for registering for the Eco-Campus International Conference 2025.</p>
            <p>Please find attached your invitation letter for the upcoming <b>Eco-Campus International Conference 2025 </b> in Malaysia.</p>
            <p>If you have any questions, feel free to contact us.</p>
            <p>Thank you,</p>
            <p>Best Regards,</p>
            <p><b>Eco-Campus International Conference 2025 Team</b></p>
          ";

        $mail->Body = $mailBody;
        $mail->send();
        $success = true;
        
        // Log successful email
        file_put_contents("visa_email.log", "Visa invitation sent to $recipientEmail ($transactionRef) at " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);
    } catch (Exception $e) {
        $errorMsg = "Visa invitation email failed for $recipientEmail: " . $e->getMessage();
        error_log($errorMsg);
        file_put_contents("visa_email_errors.log", $errorMsg . "\n", FILE_APPEND);
    }
    
    return $success;
}

function sendRegistrationConfirmationEmail($recipientEmail, $recipientName, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef) {
    $mail = new PHPMailer(true);

    try {
        // Generate QR code and PDF
        $qrData = "ECO-CAMPUS CONFERENCE REGISTRATION\n";
        $qrData .= "Name: " . $recipientName . "\n";
        $qrData .= "Email: " . $recipientEmail . "\n";
        $qrData .= "Registration: " . $registrationCategory . "\n";
        $qrData .= "Transaction: " . $transactionRef . "\n";
        $qrData .= "Gala Dinner: " . $galaDinner . "\n";
        $qrData .= "Amount: MYR " . $amountPaid . "\n";
        $qrData .= "Event: Eco-Campus International Conference 2025\n";
        $qrData .= "Date: 18-20 September 2025\n";
        $qrData .= "Location: International Youth Center, Kuala Lumpur";
        
        // Generate QR code specifically for event check-in
        $attendanceQrPath = generateQRCode($qrData, 'attendance_'.$transactionRef);
        
        // Generate invoice PDF with its own QR code
        $fileResults = generateInvoicePDF($recipientName, $recipientEmail, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef);
        $pdfFilePath = $fileResults['pdf'];
        
        // Set up email
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'erp-admin@greengrowthasia.org';
        $mail->Password = 'fxzisdzwgwyuhasz';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;
        $mail->SMTPDebug = 0;

        $mail->setFrom('erp-admin@greengrowthasia.org', 'Eco-Campus International Conference 2025');
        $mail->addAddress($recipientEmail, $recipientName);
        $mail->addBCC('erp-admin@greengrowthasia.org', 'Admin Copy');

        // Attach the PDF invoice
        $mail->addAttachment($pdfFilePath, 'Invoice_'.$transactionRef.'.pdf');
        
        // Attach the QR code as a separate file
        $mail->addAttachment($attendanceQrPath, 'Your_Conference_QR_'.$transactionRef.'.png');

        $mail->isHTML(true);
        $mail->Subject = "Registration and Payment Confirmation for the Eco-Campus International Conference 2025";

        $presentationDisplay = !empty($presentationType) ? $presentationType : 'Attendee';
        $galaDinnerDisplay = !empty($galaDinner) ? (strtolower($galaDinner) == 'yes' ? 'Yes' : 'No') : 'No';

        $mailBody = "
           <p>Dear $recipientName,</p>
        <p>Thank you for registering for the <strong>Eco-Campus International Conference 2025</strong>. We are pleased to confirm your registration and payment for the event.</p>
        
        <h3>Event Details:</h3>
        <p><strong>Conference Name:</strong> Eco-Campus International Conference 2025</p>
        <p><strong>Date:</strong> 18th to 20th September 2025</p>
        <p><strong>Location:</strong> International Youth Centre, Kuala Lumpur, Malaysia</p>
        
        <h3>Registration Summary:</h3>
        <p><strong>Registration Category:</strong> $registrationCategory</p>
        <p><strong>Payment Status:</strong> Successful</p>
        <p><strong>Conference Participation:</strong> $presentationDisplay</p>
        <p><strong>Gala Dinner:</strong> $galaDinnerDisplay</p>
        <p><strong>Amount Paid:</strong> MYR $amountPaid</p>
        <p><strong>Payment Method:</strong> $paymentMethod</p>

        <p>Your registration is now complete. If you are selected to present at the conference, please ensure that your abstract submission is completed by <strong>31st May 2025</strong>. If you are attending the Gala Dinner on 18th September, we look forward to seeing you there!</p>

        <h3>Your Conference QR Code:</h3>
        <p><img src='cid:qrcode' alt='Conference Registration QR Code' width='200' /></p>
        <p><strong>Please present this QR code during check-in at the conference to collect your badge quickly.</strong></p>
        <p>The QR code is also attached as a separate file for convenient access on your mobile device.</p>

        <p>Please find your payment receipt attached for your reference.</p>

        <p>For any questions or changes to your registration, please feel free to contact us at <a href='mailto:adilah.a@greengrowthasia.org'>adilah.a@greengrowthasia.org</a> or <a href='mailto:jessica@fee.global'>jessica@fee.global</a>.</p>

        <p>We look forward to welcoming you to the conference and an engaging experience ahead.</p>

        <p>Best regards,</p>
        <p><strong>Eco-Campus International Conference 2025 Team</strong></p>";

        $mail->AddEmbeddedImage($attendanceQrPath, 'qrcode', 'QRCode.png');
        $mail->Body = $mailBody;

        $mail->send();
        
        return json_encode(['status' => 'success', 'message' => 'Registration confirmation email sent successfully with QR code']);
    } catch (Exception $e) {
        error_log("Email sending failed: " . $e->getMessage());
        return json_encode(['status' => 'error', 'message' => $mail->ErrorInfo]);
    }
}
function submitResponseCRM($payload) {
    list($datetime, $fraction) = explode('.', $payload['eventTs']);
    $date = DateTime::createFromFormat('YmdHis', $datetime);
    $formatted_date = $date->format('Y-m-d H:i:s') . '.' . $fraction;

    if($payload['eventCode'] == 'PendingAuthorise') {
        $eventcode = 1;
    } elseif($payload['eventCode'] == 'Cancelled') {
        $eventcode = 2;
    } elseif($payload['eventCode'] == 'Authorised') {
        if($payload['eventCode'] == 'Authorised' && $payload['success'] == false) {
            $eventcode = 4;
        } else {
            $eventcode = 3;
        }
    } elseif($payload['eventCode'] == 'Failed') {
        $eventcode = 4;
    } elseif($payload['eventCode'] == 'Expired') {
        $eventcode = 5;
    } else {
        $eventcode = 1;
    }

    $cdata = [];
    $cdata["Module"] = "Presto";
    $cdata["SpKey"] = "PaymentCallBack";
    $cdata["data"] = json_encode([
        "txnRefNum" => $payload['txnRefNum'],
        "paymentRefNum"=> $payload['paymentRefNum'],
        "eventTs"=> $formatted_date,
        "amount"=> $payload['amount'],
        "EventCode" => $eventcode,
        "success" => ($payload['success'] == true)?1:0 
    ]);

    $cheader = [
        "Content-Type:text/plain",
        "client_id:".CLIENT_ID,
        "t:".TIMESTAMP,
        "sign:".SIGNATURE
    ];

    $res = postRequest(API_ENDPOINT, $cheader, json_encode($cdata));

    file_put_contents("webhook.log", print_r($cdata, true), FILE_APPEND);

    return $res;
}

function successResponse() {
    http_response_code(200);
    echo json_encode(['status' => 'success', 'message'=> 'success']);
    exit;
}

function errorResponse($errorMsg) {
    http_response_code(400);
    echo json_encode(['status' => 'failed', 'message'=> $errorMsg]);
    exit;
}

function postRequest($url, $header, $data) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    $json = json_decode($result, true);
    return $json;
}