<?php

require_once 'utility/tools.php';
require_once 'config/db_config.php';
require_once 'utility/constants.php';
date_default_timezone_set('Asia/Kuala_Lumpur');

//check transaction had been more than 30 min with no response
$select_sql = "SELECT * FROM wp_presto_donation_transaction WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 MINUTE) AND `status` = 'pending' AND (payment_callback IS NULL OR payment_callback =='')";

$select_query = mysqli_query($con, $select_sql);

if (!$select_query) 
{
    errorReponse("Error description: " . mysqli_error($con));
}

if (mysqli_num_rows($select_query) > 0) {
    // output data of each row
    while($row = mysqli_fetch_assoc($select_query)) {
        processData($con,$row);
    }
  } else {
    exit;
  }  

function processData($con, $param)
{
    $data=[];
    $data["mid"] = PRESTO_MID;
    $data["prestoMrn"] = PRESTO_MRN_WEBPAY;
    $data["txnRefNum"]=$param['donation_ref'];

    $payment_url = PRESTO_PAY_LIVE_ENDPOINT.PRESTO_PAY_QUERY_PAYMENT;
    
    $payment_header = [
        "Content-Type:application/json"
    ];

    $payment_res = postRequest($payment_url, $payment_header, json_encode($data));

    if( $payment_res == NULL || $payment_res == '')
    {
        errorReponse('Error Payment Request');
    }

    $update_callback_sql = "UPDATE wp_presto_donation_transaction 
    SET payment_callback='".json_encode($payment_res)."'
    WHERE donate_ref = '".$param['donation_ref']."'";

    $update_callback_query = mysqli_query($con, $update_callback_sql);

    if (!$update_callback_query) 
    {
        errorReponse("Error description: " . mysqli_error($con));
    }

    if($payment_res['paymentStatus'] == 'PendingAuthorise')
    {
        $update_status_sql = "UPDATE wp_presto_donation_transaction 
        SET `status` = 'failed'
        WHERE donate_ref = '".$param['donation_ref']."'";

        $update_status_query = mysqli_query($con, $update_status_sql);

        if (!$update_status_query) 
        {
            errorReponse("Error description: " . mysqli_error($con));
        }

        submitResponseCRM($param);

        successReponse();
    } else if($payment_res['paymentStatus'] == 'Authorised')
    {
        $update_status_sql = "UPDATE wp_presto_donation_transaction 
        SET `status` = 'sucess'
        WHERE donate_ref = '".$param['donation_ref']."'";

        $update_status_query = mysqli_query($con, $update_status_sql);

        if (!$update_status_query) 
        {
            errorReponse("Error description: " . mysqli_error($con));
        }

        submitResponseCRM($param);

        successReponse();
    } else
    {
        $update_status_sql = "UPDATE wp_presto_donation_transaction 
        SET `status` = 'failed'
        WHERE donate_ref = '".$param['donation_ref']."'";

        $update_status_query = mysqli_query($con, $update_status_sql);

        if (!$update_status_query) 
        {
            errorReponse("Error description: " . mysqli_error($con));
        }

        submitResponseCRM($param);

        successReponse();
    }
}

function submitResponseCRM($payload)
{
    list($datetime, $fraction) = explode('.', $payload['eventTs']);
    // Convert the main part to a DateTime object
    $date = DateTime::createFromFormat('YmdHis', $datetime);
    // Combine the formatted date and fractional seconds
    $formatted_date = $date->format('Y-m-d H:i:s') . '.' . $fraction;

    $eventcode = 1;

    if($payload['eventCode'] == 'PendingAuthorise')
    {
        $eventcode = 1;
    } else if($payload['eventCode'] == 'Cancelled')
    {
        $eventcode = 2;
    } else if($payload['eventCode'] == 'Authorised')
    {
        $eventcode = 3;
    } else if($payload['eventCode'] == 'Failed')
    {
        $eventcode = 4;
    } else if($payload['eventCode'] == 'Expired')
    {
        $eventcode = 5;
    }

    $cdata = [];
    $cdata["Module"] = "Presto";
    $cdata["SpKey"] = "PaymentCallBack";
    $cdata["data"] = json_encode([
        "txnRefNum" => $payload['txnRefNum'],
        "paymentRefNum"=> $payload['paymentRefNum'],
        "eventTs"=> $formatted_date,
        "amount"=> $payload['amount'],
        "EventCode" => $eventcode
    ]);

    $cheader = [
        "Content-Type:text/plain",
        "client_id:".CLIENT_ID,
        "t:".TIMESTAMP,
        "sign:".SIGNATURE
    ];

    $res = postRequest(API_ENDPOINT, $cheader, json_encode($cdata));

    file_put_contents("webhook.log", print_r($cdata, true), FILE_APPEND);

    return $res;
}
function successReponse()
{
    echo json_encode(['status' => 'success', 'message'=> 'success']);
    die;
}

function errorReponse($errorMsg)
{
    echo json_encode(['status' => 'success', 'message'=> $errorMsg]);
    die;
}

function postRequest($url, $header, $data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);

    $json = json_decode($result, true);

    return $json;
}   

?>