<?php 
// Set the base URL for payment processing
$base_url = "https://presto-ext.enovax.com/v1/ext/payment/init";

// Generate a random transaction reference number
$txnRefNum = rand(10000, 999999);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Form</title>
    <link rel="stylesheet" href="styles.css">
    <script>
        // Function to allow only numeric input
        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : event.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57)) return false;
            return true;
        }

        // Function to update the amount input when a radio button is selected
        function updateAmount(element) {
            document.getElementById("amount").value = element.value;
        }

        // Function to validate and submit the form
        function SubmitValidation() {
            var amount = document.getElementById("amount").value;
            if (amount == "" || isNaN(amount) || amount <= 0) {
                alert("Please enter a valid amount.");
                return false;
            }
            document.getElementById("paymentForm").submit();
        }
    </script>
</head>
<body>

    <h2>Conference Registration Payment</h2>

    <form action="init_payment.php" method="POST" id="paymentForm">

        <!-- Hidden Fields -->
        <input type="hidden" name="prestoMrn" value="PM250314DFGGAX"/>
        <input type="hidden" name="txnType" value="WebPay"/>
        <input type="hidden" name="txnRefNum" value="<?php echo $txnRefNum; ?>"/>
        <input type="hidden" name="displayDesc" value="GGAF Conference Registration"/>
        <input type="hidden" name="redirectUrl" value="https://icfe.greengrowthasia.org/payment/response.php"/>

        <!-- Amount Selection -->
        <div class="amount_box">
            <label>Amount (RM): </label>
            <input type="text" name="Amount" id="amount" placeholder="Enter Amount" onkeypress="return isNumberKey(event)" required />
        </div>

        <div class="radio_group">
            <label><input type="radio" name="radio_selection" value="100" onchange="updateAmount(this)"> Student RM 100</label>
            <label><input type="radio" name="radio_selection" value="200" onchange="updateAmount(this)"> Speaker RM 200</label>
        </div>

        <!-- Personal Information -->
        <h3>Personal Details</h3>
        <label>First Name *</label>
        <input type="text" name="FirstName" required>

        <label>Last Name *</label>
        <input type="text" name="LastName" required>

        <label>Email *</label>
        <input type="email" name="Email" required>

        <label>Mobile *</label>
        <input type="text" name="Mobile" required>

        <h3>Billing Address</h3>
        <label>Address *</label>
        <input type="text" name="Address1" required>

        <label>City *</label>
        <input type="text" name="City" required>

        <label>State *</label>
        <input type="text" name="State" required>

        <label>Country *</label>
        <input type="text" name="Country" value="Malaysia" readonly>

        <!-- Submit Button -->
        <button type="button" onclick="SubmitValidation()">Proceed to Payment</button>
    </form>
<script>
    $(document).ready(function () {
    $("#paymentForm").submit(function (event) {
        event.preventDefault(); 

        var paymentData = $(this).serialize(); 

        $.ajax({
            url: '../payment/init_payment.php', 
            data: paymentData,
            method: 'POST',
            dataType: 'json', 
            beforeSend: function () {
                Swal.fire({
                    title: 'Processing Payment...',
                    text: 'Please wait while we process your transaction.',
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    willOpen: () => {
                        Swal.showLoading();
                    }
                });
            },
            success: function (result) {
                Swal.close(); // Close the loading alert

                if (result.success === true) {
                    if (result.data.paymentStatus === 'PendingAuthorise' && result.data.success === true) {
                        window.location.href = result.data.paymentUrl; // Redirect to payment gateway
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Payment Failed',
                        text: result.message || 'Transaction could not be processed.'
                    });
                }
            },
            error: function (xhr, status, error) {
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'AJAX Error',
                    text: 'Something went wrong. Please try again later.'
                });
                console.error("AJAX Error:", status, error);
            }
        });
    });
});

</script>
</body>
</html>
