<?php

require_once 'config/db_config.php';
require_once 'utility/tools.php';
require_once 'utility/constants.php';

date_default_timezone_set('Asia/Kuala_Lumpur');

if (sizeof($_POST)>0){

    $Tax_Exemption = 0;

    if(empty($_POST["FirstName"]))
    {
        errorReponse("First Name is empty");
    }

    if(empty($_POST["LastName"]))
    {
        errorReponse("Last Name is empty");
    }

    if(empty($_POST["Email"]))
    {
        errorReponse("Email is empty");
    }

    if(empty($_POST["Mobile"]))
    {
        errorReponse("Mobile is empty");
    }

    if(empty($_POST["Donate_As"]))
    {
        errorReponse("Donate As is empty");
    } else {
        if($_POST["Donate_As"] == 'individual')
        {
            if(empty($_POST["nric"]))
            {
                errorReponse("Donor NRIC is empty");
            }
        } else if($_POST["Donate_As"] == 'company')
        {
            if(empty($_POST["brn"]))
            {
                errorReponse("Donor BRN is empty");
            }
        }
    }

    if(!empty($_POST["tax_exemption"]))
    {
        $Tax_Exemption = (int)$_POST["tax_exemption"];

        if(empty($_POST["tin"]))
        {
            errorReponse("TIN is empty");
        }
    }

    if(empty($_POST["Address1"]))
    {
        errorReponse("Address1 is empty");
    }

    if(empty($_POST["Postcode"]))
    {
        errorReponse("Post Code is empty");
    }

    if(empty($_POST["City"]))
    {
        errorReponse("City is empty");
    }

    if(empty($_POST["Country"]))
    {
        errorReponse("Country is empty");
    }

    if(empty($_POST["Amount"]))
    {
        errorReponse("Amount is empty");
    } else {
        if((int)$_POST["Amount"] < 10)
        {
            errorReponse("Minimum Donation Amount is RM10.00");
        }
    }

    if(empty($_POST["g-recaptcha-response"]))
    {
        errorReponse("Captcha verification failed");
    }

    $recaptchaResponse = $_POST['g-recaptcha-response'];
              
    $post_data = 'secret='.GRECAPTCHA_KEY.'&response='.$recaptchaResponse;

    $header_recaptcha = [
        'Content-Type:application/x-www-form-urlencoded'
    ];
    
    $recaptcha_res = postURLRequest(GRECAPTCHA_ENDPOINT, $header_recaptcha, $post_data);

    if(!$recaptcha_res)
    {
        errorReponse("Captcha verification failed");
    }

    if($recaptcha_res['success'] == false)
    {
        errorReponse("Captcha verification failed");
    }

    $donation_ref = getRandomStringSha1();
    
    $insert_sql = "INSERT INTO wp_presto_donation_transaction_test (donate_ref,firstname,lastname,email,mobile_no,donate_as,nric,brn,tax_exemption,tin,newsletter,address1,address2,postcode,city,states,country,amount,created_at) 
    VALUE('".$donation_ref."',
    '".$_POST["FirstName"]."',
    '".$_POST["LastName"]."',
    '".$_POST["Email"]."', 
    '".$_POST["Mobile"]."',
    '".$_POST['Donate_As']."',
    '".$_POST['nric']."',
    '".$_POST['brn']."',
    '".$Tax_Exemption."',
    '".$_POST['tin']."',
    '0',
    '".$_POST["Address1"]."',
    '".$_POST["Address2"]."',
    '".$_POST["Postcode"]."',
    '".$_POST["City"]."',
    '".$_POST["State"]."',
    '".$_POST["Country"]."',
    '".$_POST["Amount"]."',
    '".date("Y-m-d H:i:s")."' 
    )";
    
    // echo "sql=".$insert_sql;die;
    $query = mysqli_query($con, $insert_sql);
    
    if (!$query) 
    {
        errorReponse("Error description: " . mysqli_error($con));
    }

    $timestamp = date('YmdHis') . '.' . sprintf('%03d', round(microtime(true) * 1000) % 1000);
    $datetime = date('Y-m-d H:i:s') . '.' . sprintf('%03d', round(microtime(true) * 1000) % 1000);


    $data=[];
    $data["mid"] = PRESTO_STAGING_MID;
    $data["prestoMrn"] = PRESTO_MRN_STAGING_WEBPAY;
    $data["qrValue"]="";
    $data["payerRefNum"]= "";
    $data["deviceRefNum"]= "";
    $data["deviceIp"]= "";
    $data["txnType"]= "WebPay";
    $data["txnRefNum"]= $donation_ref;
    $data["displayDesc"]= 'Donation Fund';
    $data["itemList"]= '';
    $data["transactionalData"]= '';
    $data["amount"]= (int)$_POST["Amount"]*100;
    $data["currencyCode"]= 'MYR';
    $data["notifyUrl"]= PRESTO_NOTIFY_URL;
    $data["redirectUrl"]= PRESTO_STAGING_REDIRECT_URL;
    $data["sessionValidity"]= '';
    $data["additionalData"]= '';
    $data["mode"]= '';
    $data["modeData"]= '';
    $data["allowedPaymentMethods"]= '';
    $data["bindData"]= '';
    $data["themeRefNum"]= '';
    $data["receiptEmail"]= $_POST["Email"];
    $data["receiptName"]= $_POST["FirstName"]." ".$_POST["LastName"];
    $data["ts"] = $timestamp;

    $signature = generateSignature($data,'staging');

    $data['signature'] = $signature;

    $payment_url = PRESTO_PAY_DEV_ENDPOINT.PRESTO_PAY_INIT_PAYMENT;
    
    $payment_header = [
        "Content-Type:application/json"
    ];

    $update_request_sql = "UPDATE wp_presto_donation_transaction_test
        SET request_body='".json_encode($data)."'
        WHERE donate_ref = '".$donation_ref."'";
    
    // echo "sql=".$insert_sql;die;
    $update_request_query = mysqli_query($con, $update_request_sql);
    
    if (!$update_request_query) 
    {
        errorReponse("Error description: " . mysqli_error($con));
    }

    $payment_res = postRequest($payment_url, $payment_header, json_encode($data));

    if( $payment_res == NULL || $payment_res == '')
    {
        errorReponse('Error Payment Request');
    }

    $update_response_sql = "UPDATE wp_presto_donation_transaction_test
    SET request_response='".json_encode($payment_res)."'
    WHERE donate_ref = '".$donation_ref."'";

    // echo "sql=".$insert_sql;die;
    $update_response_query = mysqli_query($con, $update_response_sql);

    if (!$update_response_query) 
    {
        errorReponse("Error description: " . mysqli_error($con));
    }

    $payment_status = 1;

    if($payment_res["paymentStatus"] == 'PendingAuthorise')
    {
        $payment_status = 1;
    } else if($payment_res["paymentStatus"] == 'Success')
    {
        $payment_status = 2;
    } else if($payment_res["paymentStatus"] == 'Failed')
    {
        $payment_status = 3;
    }

    $cdata = [];
    $cdata["Module"] = "Presto";
    $cdata["SpKey"] = "PaymentGateway";
    $cdata["data"]["PaymentResponse"]["paymentRefNum"] = $payment_res["paymentRefNum"];
    $cdata["data"]["PaymentResponse"]["txnRefNum"] = $payment_res["txnRefNum"];

    $cdata["data"]["PaymentResponse"]["paymentStatus"] = $payment_status;
    $cdata["data"]["PaymentResponse"]["success"] = "1";
    $cdata["data"]["PaymentResponse"]["amount"] = $_POST["Amount"];
    $cdata["data"]["PaymentResponse"]["paymentRequestDate"] = $datetime;
     
    $cdata["data"]["CustInfo"]["LastName"] = $_POST["LastName"];
    $cdata["data"]["CustInfo"]["FirstName"] = $_POST["FirstName"];
    $cdata["data"]["CustInfo"]["Email"] = $_POST["Email"];
    $cdata["data"]["CustInfo"]["Mobile"] = $_POST["Mobile"];
    $cdata["data"]["CustInfo"]["Donate_As"] = $_POST["Donate_As"];
    $cdata["data"]["CustInfo"]["Tax_Exemption"] = $Tax_Exemption;
    $cdata["data"]["CustInfo"]["BRN"]= ($_POST['brn']) ? $_POST['brn']: "";
    $cdata["data"]["CustInfo"]["NRIC"]= ($_POST['nric']) ? $_POST['nric']: "";
    $cdata["data"]["CustInfo"]["TINNo"]= ($_POST['tin']) ? $_POST['tin']: "";
    $cdata["data"]["CustInfo"]["Address1"] = $_POST["Address1"];
    $cdata["data"]["CustInfo"]["Address2"] = $_POST["Address2"];
    $cdata["data"]["CustInfo"]["Postcode"] = $_POST["Postcode"];
    $cdata["data"]["CustInfo"]["City"] = $_POST["City"];
    $cdata["data"]["CustInfo"]["State"] = $_POST["State"];
    $cdata["data"]["CustInfo"]["Country"] = $_POST["Country"];
    
    $cheader = [
        "Content-Type:text/plain",
        "client_id:".CLIENT_ID,
        "t:".TIMESTAMP,
        "sign:".TEST_SIGNATURE,
    ];

    $res = postRequest(TEST_API_ENDPOINT, $cheader, json_encode($cdata));

    if(!$res)
    {
        errorReponse("Error");
    }

    successReponse($payment_res);
}

function successReponse($data)
{
    echo json_encode(["success" => true, "data" => $data, "message" => "success"]);
    die;
}

function errorReponse($errorMsg,$data=[])
{
    echo json_encode(["success" => false, "data" => $data, "message" => $errorMsg]);
    die;
}

function postRequest($url, $header, $data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);

    if (curl_errno($ch)) 
    {
        $error_msg = curl_error($ch);
    }

    curl_close($ch);

    if (isset($error_msg)) 
    {
       return $error_msg;
    }
    
    $json = json_decode($result, true);

    return $json;
}  

function postURLRequest($url, $header, $data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);

    $json = json_decode($result, true);

    return $json;
}  
?>