<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');

if (isset($_FILES['image']) && $_FILES['image']['error'] === 0) {
    $tmpName = $_FILES['image']['tmp_name'];
    $originalName = basename($_FILES['image']['name']);
    $tempDir = 'photo/temp/';

    if (!is_dir($tempDir)) {
        mkdir($tempDir, 0755, true);
    }

    $uniqueName = time() . '_' . uniqid() . '_' . $originalName;
    $targetPath = $tempDir . $uniqueName;

    if (move_uploaded_file($tmpName, $targetPath)) {
        echo json_encode([
            'success' => true,
            'url' => $targetPath
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to move uploaded file.']);
    }
} else {
    $error = isset($_FILES['image']['error']) ? $_FILES['image']['error'] : 'No file uploaded';
    echo json_encode(['success' => false, 'message' => 'Upload error: ' . $error]);
}
