<?php
header('Content-Type: application/json');

require_once './lib/init.php';
require_once __DIR__ . '/../config/db_config.php';
require_once __DIR__ . '/../utility/tools.php';

\Stripe\Stripe::setApiKey('sk_test_51ORZMGAea8RQqr9QjXKq5yeZijeh68frXazg3RuRKNPy4DFd3QmsWs8ZRzxQUHqBWkoKa9MTWVSihm5yHzaugUXO00IqkGkssO');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON input.');
    }

    // Determine if this is a student registration
    $isStudent = ($input["registrationType"] ?? '') == 'Student';
    

    $FirstName = $isStudent ? ($input["studentFirstName"] ?? '') : ($input["firstName"] ?? '');
    $LastName = $isStudent ? ($input["studentLastName"] ?? '') : ($input["lastName"] ?? '');
    $Phone = $isStudent ? ($input["studentPhone"] ?? '') : ($input["phone"] ?? '');
    $Email = $isStudent ? ($input["studentEmail"] ?? '') : ($input["email"] ?? '');
    $BadgeName = $isStudent 
    ? (!empty($input["studentBadgename"]) ? $input["studentBadgename"] : null)
    : (!empty($input["Badgename"]) ? $input["Badgename"] : null);
    $Visarequired = $isStudent ? ($input["studentVisaRequired"] ?? '') : ($input["visaRequired"] ?? '');
    
    $Discovery = is_array($input["discovery"]) ? implode(",", $input["discovery"]) : ($input["discovery"] ?? '');
    $PassportExpiry = !empty($input["passportExpiry"]) ? $input["passportExpiry"] : null;
    $amount = isset($input["amount"]) ? (int)$input["amount"] : 0;
    $photoUrl = $isStudent 
        ? ($input["imageUrl_student"] ?? '') 
        : ($input["imageUrl"] ?? '');
    
    $donation_ref = getRandomStringSha1();
  
    function esc($val, $con) {
        return $val !== null ? "'" . $con->real_escape_string($val) . "'" : "NULL";
    }

    $sql = "INSERT INTO wpcf_presto_reg_transaction (
        donate_ref, firstName, lastName, phone, email, presentationType, registrationType, 
        presentation, workshopDetails, galaDinner, organization, orgCountry, position, 
        nationality, visaRequired, institution, institutionCountry, levelOfStudy, 
        department, studentId, studentNationality, embassyLocation, passportNumber, 
        passportExpiry, dietaryRestrictions, dietaryDetails, discovery, otherDiscoveryDetails, 
        emailUpdates, accessibility, volunteer, agreeTerms, amount,Preferred_Name,photo_url,created_at
    ) VALUES (
        " . esc($donation_ref, $con) . ",
        " . esc($FirstName, $con) . ",
        " . esc($LastName, $con) . ",
        " . esc($Phone, $con) . ",
        " . esc($Email, $con) . ",
        " . esc($input["presentationType"] ?? '', $con) . ",
        " . esc($input["registrationType"] ?? '', $con) . ",
        " . esc($input["presentation"] ?? '', $con) . ",
        " . esc($input["workshopDetails"] ?? '', $con) . ",
        " . esc($input["galaDinner"] ?? '', $con) . ",
        " . esc($input["organization"] ?? '', $con) . ",
        " . esc($input["orgCountry"] ?? '', $con) . ",
        " . esc($input["position"] ?? '', $con) . ",
        " . esc($input["nationality"] ?? '', $con) . ",
        " . esc($Visarequired, $con) . ",
        " . esc($input["institution"] ?? '', $con) . ",
        " . esc($input["institutionCountry"] ?? '', $con) . ",
        " . esc($input["levelOfStudy"] ?? '', $con) . ",
        " . esc($input["department"] ?? '', $con) . ",
        " . esc($input["studentId"] ?? '', $con) . ",
        " . esc($input["studentNationality"] ?? '', $con) . ",
        " . esc($input["embassyLocation"] ?? '', $con) . ",
        " . esc($input["passportNumber"] ?? '', $con) . ",
        " . ($PassportExpiry ? esc($PassportExpiry, $con) : "NULL") . ",
        " . esc($input["dietaryRestrictions"] ?? '', $con) . ",
        " . esc($input["dietaryDetails"] ?? '', $con) . ",
        " . esc($Discovery, $con) . ",
        " . esc($input["otherDiscoveryDetails"] ?? '', $con) . ",
        " . esc($input["emailUpdates"] ?? '', $con) . ",
        " . esc($input["accessibility"] ?? '', $con) . ",
        " . esc($input["volunteer"] ?? '', $con) . ",
        " . esc($input["agreeTerms"] ?? '', $con) . ",
        " . esc($amount, $con) . ",
         " . esc($BadgeName, $con) . ",
        " . esc( $photoUrl, $con) . ",
        '" . date("Y-m-d H:i:s") . "'
    )";

    if (!$con->query($sql)) {
        throw new Exception("Database insert error: " . $con->error);
    }

    $session = \Stripe\Checkout\Session::create([
        'payment_method_types' => ['card'],
        'line_items' => [[
            'price_data' => [
                'currency' => 'eur',
                'product_data' => ['name' => 'ECIC25 Registration'],
                'unit_amount' => $amount * 100,
            ],
            'quantity' => 1,
        ]],
        'mode' => 'payment',
        'success_url' => 'https://icfe.greengrowthasia.org/payment/stripe/stripe-callback.php?session_id={CHECKOUT_SESSION_ID}&txnRefNum=' . $donation_ref,
        'cancel_url' => 'https://yourdomain.com/payment-canceled',
        'customer_email' => $Email,
        'metadata' => ['transaction_ref' => $donation_ref],
    ]);

    echo json_encode([
        'success' => true,
        'url' => $session->url,
        'id' => $session->id,
        'reference' => $donation_ref
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>