<?php
ob_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require_once './lib/init.php';
require_once __DIR__ . '/../config/db_config.php';
require_once __DIR__ . '/../utility/tools.php';

require __DIR__ . '/../vendor/PHPMailer/Exception.php';
require __DIR__ . '/../vendor/PHPMailer/PHPMailer.php';
require __DIR__ . '/../vendor/PHPMailer/SMTP.php';
require __DIR__ . '/../vendor/recaptcha/autoload.php';
require __DIR__ . '/../includes/fpdf/fpdf.php';

if (!isset($con) || !($con instanceof mysqli)) {
    die("Database connection failed");
}

function generateEventQRCode($recipientName, $recipientEmail, $registrationCategory, $presentationType, $galaDinner, $transactionRef, $amountPaid) {
    require_once __DIR__ . '/../vendor/phpqrcode/phpqrcode/qrlib.php';
    
    $qrDir = __DIR__ . '/../qrcodes';
    if (!file_exists($qrDir)) {
        if (!mkdir($qrDir, 0777, true)) {
            throw new Exception("Failed to create QR code directory: $qrDir");
        }
    }
    
    $qrData = 
        "Eco-Campus International Conference 2025\n" .
        "Name            : $recipientName\n" .
        "Email           : $recipientEmail\n" .
        "Registration Type: $registrationCategory\n" .
        "Gala Dinner     : $galaDinner\n" .
        "Transaction Ref : $transactionRef\n" .
        "Amount EUR      : $amountPaid\n" .
        "Location        : International Youth Center, Kuala Lumpur\n" .
        "Date            : 18-20 September 2025";
    
    $qrFilePath = $qrDir . '/qr_' . $transactionRef . '.png';
    QRcode::png($qrData, $qrFilePath, QR_ECLEVEL_L, 10);
    
    return $qrFilePath;
}

function generateInvoicePDF($recipientName, $recipientEmail, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef) {
    $pdf = new FPDF();
    $pdf->AddPage();
    
    // Logo positioning
    $logoPath = __DIR__ . '/../images/headerlogo.png';
    if (file_exists($logoPath)) {
        $pdf->Image($logoPath, 10, 10, 50);
    }

    $headerImagePath = __DIR__ . '/../images/GGAF.png';
    if (file_exists($headerImagePath)) {
        $pdf->Image($headerImagePath, 150, 10, 50);
    }

    // Conference title
    $pdf->SetFont('Arial','B',16);
    $pdf->SetY(40);
    $pdf->Cell(0,10,'Eco-Campus International Conference 2025',0,1,'C');

    // Address block
    $pdf->SetFont('Arial','',10);
    $pdf->SetY(50);
    $pdf->MultiCell(0, 5, 
        "International Youth Center, Kuala Lumpur, Malaysia\n".
        "18th to 20th September 2025",
        0, 'C');

    // Line separator
    $pdf->SetDrawColor(200, 200, 200);
    $pdf->Line(10, $pdf->GetY() + 5, 200, $pdf->GetY() + 5);
    $pdf->SetY($pdf->GetY() + 10);

    // Invoice details
    $label = 'Transaction Number:';
    $pdf->SetFont('Arial', 'B', 12); 
    $labelWidth = $pdf->GetStringWidth($label) + 2;
    $pdf->Cell($labelWidth, 10, $label);
    $pdf->Cell(0, 10, $transactionRef, 0, 1); 
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Payment Date:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,date('Y-m-d'),0,1);
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Name:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,$recipientName,0,1);
    
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(40,10,'Email:');
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,$recipientEmail,0,1);
    
    // Item table
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(100,10,'Description',1,0);
    $pdf->Cell(40, 10, iconv('UTF-8', 'Windows-1252', 'Amount EUR'), 1, 1);
    
    // Calculate prices
    $registrationPrice = ($registrationCategory == 'General') ? 100 : 50;
    $galaDinnerPrice = ($galaDinner == 'Yes') ? 30 : 0;
    $totalAmount = $registrationPrice + $galaDinnerPrice;

    // Registration row
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(100,10, ucfirst(strtolower($registrationCategory)) . ' Registration',1,0);
    $pdf->Cell(40,10, number_format($registrationPrice, 2),1,1,'R');

    // Gala Dinner row (if selected)
    if ($galaDinner == 'Yes') {
        $pdf->Cell(100,10, 'Gala Dinner',1,0);
        $pdf->Cell(40,10, number_format($galaDinnerPrice, 2),1,1,'R');
    }

    // Presentation Type (free, no cost)
    if (!empty($presentationType)) {
        $pdf->Cell(100,10, 'Presentation Type: ' . $presentationType,1,0);
        $pdf->Cell(40,10, '-',1,1,'R');
    }
    
    // Total row
    $pdf->SetFont('Arial','B',12);
    $pdf->Cell(100,10, 'Total',1,0);
    $pdf->Cell(40,10, number_format($totalAmount, 2),1,1,'R');
    $pdf->Ln(10);
    
    // Payment method
    $pdf->Cell(0,10,'Payment Method: ' . $paymentMethod,0,1);
    $pdf->Ln(5);
    
    // Generate and add QR Code
    $qrCodePath = generateEventQRCode($recipientName, $recipientEmail, $registrationCategory, $presentationType, $galaDinner, $transactionRef, $amountPaid);
    if (file_exists($qrCodePath)) {
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'Your Conference Registration QR Code:', 0, 1, 'C');
        $pdf->Ln(5);
        $pdf->Image($qrCodePath, ($pdf->GetPageWidth() - 40) / 2, $pdf->GetY(), 40);
        $pdf->Ln(40);
        $pdf->SetFont('Arial', '', 10);
        $pdf->MultiCell(0, 5, 'Please present this QR code at the registration desk to check in quickly.', 0, 'C');
    }
    
    // Footer
    $pdf->SetFont('Arial','I',10);
    $pdf->Cell(0,16,'THANK YOU FOR YOUR PAYMENT! ',0,1,'C');
    $pdf->Cell(0,16,'SEE YOU IN KUALA LUMPUR!!',0,1,'C');
    
    // Save PDF
    $invoiceDir = __DIR__ . '/../invoices';
    if (!file_exists($invoiceDir)) {
        if (!mkdir($invoiceDir, 0777, true)) {
            throw new Exception("Failed to create invoice directory: $invoiceDir");
        }
    }
    $pdfFilePath = $invoiceDir . '/invoice_' . $transactionRef . '.pdf';
    $pdf->Output($pdfFilePath, 'F');
    
    return $pdfFilePath;
}

function generateVisaInvitationPDF($recipientName, $recipientEmail, $passportNumber, $passportExpiry, $embassyLocation, $participationType) {
    $pdf = new FPDF();
    $pdf->AddPage();
    
    // Set margins
    $pdf->SetTopMargin(30);
    $pdf->SetLeftMargin(20);
    $pdf->SetRightMargin(20); 
    $pdf->SetAutoPageBreak(false);

    // Add left logo
    $leftLogoPath = __DIR__ . '/../images/GGAF-logo-2.png';
    if (file_exists($leftLogoPath)) {
        $pdf->Image($leftLogoPath, 20, 10, 30);  
    }
    
    // Add right logo
    $rightLogoPath = __DIR__ . '/../images/Empowering Youth_PNG-04.png';
    if (file_exists($rightLogoPath)) {
        $pdf->Image($rightLogoPath, 140, 10, 60); 
    }

    // Position after logos
    $pdf->SetY(50);

    // Date
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, date('F j, Y'), 0, 1, 'L'); 
    $pdf->Ln(3);

    // To whom it may concern
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, 'To whom it may concern', 0, 1);
    $pdf->Ln(3);

    // Subject line
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 6, 'Subject: Invitation Letter for Visa Application  ' . $recipientName, 0, 1);
    $pdf->Ln(3);

    // Dear Sir/Madam
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(0, 6, 'Dear Sir/Madam,', 0, 1);
    $pdf->Ln(3);

    // Main content with highlighting key information
    $pdf->SetFont('Arial', '', 10);
    
    // First paragraph
    $pdf->Write(5, 'Green Growth Asia Foundation, the National Operator of the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Foundation for Environmental Education (FEE)');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' in Malaysia, is pleased to invite ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $recipientName);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', holder of passport number ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $passportNumber);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', expiring on ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $passportExpiry);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', from ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $embassyLocation);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ', to participate as ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $participationType);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' at the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Eco-Campus International Conference 2025');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, '.');
    $pdf->Ln(8);
    
    // Second paragraph
    $pdf->Write(5, 'The conference will take place from ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, '18th to 20th September 2025');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' at the ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'International Youth Centre');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' in Kuala Lumpur, Malaysia. We encourage participants to arrive a day in advance, and they may extend their stay at their discretion.');
    $pdf->Ln(8);
    
    // Third paragraph
    $pdf->Write(5, 'We kindly request your assistance in granting the necessary visa to allow ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, $recipientName);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' to attend this conference. For further information, please contact ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'Dr. Balamurugan Ratha Krishnan, CEO, at +6012-2166826');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, ' or ');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Write(5, 'balamurugan.rk@greengrowthasia.org');
    $pdf->SetFont('Arial', '', 10);
    $pdf->Write(5, '.');
    $pdf->Ln(8);
    
    // Thank you
    $pdf->Write(5, 'Thank you for your consideration.');
    $pdf->Ln(12);
    
    // Signature section
    $pdf->Cell(0, 5, 'Yours sincerely,', 0, 1);
    $pdf->Ln(5);
    
    // Add signature logo if available
    $signatureLogoPath = __DIR__ . '/../images/Sign.png';
    if (file_exists($signatureLogoPath)) {
        $pdf->Image($signatureLogoPath, 20, $pdf->GetY(), 40);
        $pdf->Ln(20);
    } else {
        $pdf->Ln(15); // Space for signature if no image
    }
    
    // Signatory details
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(0, 5, 'on behalf of Green Growth Asia Foundation', 0, 1);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 5, 'Balamurugan Ratha Krishnan', 0, 1);
    $pdf->SetFont('Arial', 'I', 10);
    $pdf->Cell(0, 5, 'Chief Executive Officer', 0, 1);

    // Footer
    $pdf->SetY(-15);
    $pdf->SetFont('Arial', '', 8);
    $footerText = "GREEN GROWTH ASIA FOUNDATION (1271-0843) | ".
                 "HQ: No. 21-2, Jalan DR 1, Tarnan Delima, 75150 Bukit Baru, Meleika | ".
                 "Branch: A-02-10, Plaza Damas 3, Jalan Sri Harlamas 1, 50480 Kuala Lumpur";
    $pdf->MultiCell(0, 4, $footerText, 0, 'C');
    
    $contactText = "Tel: +606-230 0038 (HQ), +603-6211 2869 (Branch) | Website: www.greengrowthasia.org";
    $pdf->MultiCell(0, 4, $contactText, 0, 'C');
    
    // Save PDF
    $visaDir = __DIR__ . '/../visa_letters';
    if (!file_exists($visaDir)) {
        mkdir($visaDir, 0777, true);
    }
    $pdfFilePath = $visaDir . '/visa_invitation_' . preg_replace('/[^a-zA-Z0-9]/', '_', $recipientName) . '.pdf';
    $pdf->Output($pdfFilePath, 'F');
    
    return $pdfFilePath;
}
function sendVisaInvitationEmail($recipientEmail, $recipientName, $passportNumber, $passportExpiry, $embassyLocation, $embassyName, $embassyAddress, $registrationCategory, $presentationType, $transactionRef) {
    $mail = new PHPMailer(true);

    try {
        // Generate visa invitation letter
        $participationType = !empty($presentationType) ? "a Presenter ($presentationType)" : "an Attendee";
        $visaFilePath = generateVisaInvitationPDF($recipientName, $recipientEmail, $passportNumber, $passportExpiry, $embassyLocation, $participationType);
        
        // Generate invoice (reusing existing function)
        $invoiceFilePath = generateInvoicePDF(
            $recipientName, 
            $recipientEmail, 
            $registrationCategory, 
            $presentationType, 
            0, // Amount not needed for visa letter
            'No', // Gala dinner not needed
            '', // Payment method not needed
            $transactionRef
        );

        // SMTP Configuration
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'erp-admin@greengrowthasia.org';
        $mail->Password = 'fxzisdzwgwyuhasz';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;

        $mail->setFrom('erp-admin@greengrowthasia.org', 'Eco-Campus International Conference 2025');
        $mail->addAddress($recipientEmail, $recipientName);
        $mail->Subject = "Visa Application Invitation Letter to Eco-Campus International Conference 2025";

        // Attachments
        $mail->addAttachment($visaFilePath, 'Visa_Invitation_Letter_'.$transactionRef.'.pdf');
        // $mail->addAttachment($invoiceFilePath, 'Invoice_'.$transactionRef.'.pdf');

        // Email content
        $mail->isHTML(true);
        
   
            $mailBody = "
            <p>Dear $recipientName,</p>
            <p>Thank you for registering for the Eco-Campus International Conference 2025.</p>
            <p>Please find attached your invitation letter for the upcoming <b>Eco-Campus International Conference 2025 </b> in Malaysia.</p>
            <p>If you have any questions, feel free to contact us.</p>
            <p>Thank you,</p>
            <p>Best Regards,</p>
            <p><b>Eco-Campus International Conference 2025 Team</b></p>
          ";
    

        $mail->Body = $mailBody;
        $mail->send();
        
        return true;
    } catch (Exception $e) {
        error_log("Visa invitation email failed: " . $e->getMessage());
        return false;
    }
}

function sendRegistrationConfirmationEmail($recipientEmail, $recipientName, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef) {
    $mail = new PHPMailer(true);

    try {
        // Generate QR code and PDF
        $qrCodePath = generateEventQRCode($recipientName, $recipientEmail, $registrationCategory, $presentationType, $galaDinner, $transactionRef, $amountPaid);
        $pdfFilePath = generateInvoicePDF($recipientName, $recipientEmail, $registrationCategory, $presentationType, $amountPaid, $galaDinner, $paymentMethod, $transactionRef);
        
        // SMTP Configuration
        $mail->isSMTP();
        $mail->Host = 'smtp.gmail.com';
        $mail->SMTPAuth = true;
        $mail->Username = 'erp-admin@greengrowthasia.org';
        $mail->Password = 'fxzisdzwgwyuhasz';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = 465;

        $mail->setFrom('erp-admin@greengrowthasia.org', 'Eco-Campus International Conference 2025');
        $mail->addAddress($recipientEmail, $recipientName);

        // Attachments
        $mail->addAttachment($pdfFilePath, 'Invoice_'.$transactionRef.'.pdf');
        $mail->addAttachment($qrCodePath, 'Your_Conference_QR_'.$transactionRef.'.png');
        $mail->AddEmbeddedImage($qrCodePath, 'qrcode', 'QRCode.png');

        // Email content
        $mail->isHTML(true);
        $mail->Subject = "Registration and Payment Confirmation for the Eco-Campus International Conference 2025";

        $presentationDisplay = !empty($presentationType) ? $presentationType : 'Attendee';
        $galaDinnerDisplay = ($galaDinner == 'Yes') ? 'Yes' : 'No';

        $mailBody = "
        <p>Dear $recipientName,</p>
        <p>Thank you for registering for the <strong>Eco-Campus International Conference 2025</strong>. We are pleased to confirm your registration and payment for the event.</p>
        
        <h3>Event Details:</h3>
        <p><strong>Conference Name:</strong> Eco-Campus International Conference 2025</p>
        <p><strong>Date:</strong> 18th to 20th September 2025</p>
        <p><strong>Location:</strong> International Youth Centre, Kuala Lumpur, Malaysia</p>
        
        <h3>Registration Summary:</h3>
        <p><strong>Registration Category:</strong> $registrationCategory</p>
        <p><strong>Payment Status:</strong> Successful</p>
        <p><strong>Conference Participation:</strong> $presentationDisplay</p>
        <p><strong>Gala Dinner:</strong> $galaDinnerDisplay</p>
        <p><strong>Amount Paid:</strong> MYR $amountPaid</p>
        <p><strong>Payment Method:</strong> $paymentMethod</p>

        <p>Your registration is now complete. If you are selected to present at the conference, please ensure that your abstract submission is completed by <strong>31st May 2025</strong>. If you are attending the Gala Dinner on 18th September, we look forward to seeing you there!</p>

          <h3>Your Conference QR Code:</h3>
        <p><img src='cid:qrcode' alt='Conference QR Code' width='250' /></p>

         <p><strong>Please present this QR code during check-in at the conference to collect your badge quickly.</strong></p>
        <p>The QR code is also attached as a separate file for convenient access on your mobile device.</p>

        <p>Please find your payment receipt attached for your reference.</p>

        <p>For any questions or changes to your registration, please feel free to contact us at <a href='mailto:adilah.a@greengrowthasia.org'>adilah.a@greengrowthasia.org</a> or <a href='mailto:jessica@fee.global'>jessica@fee.global</a>.</p>

        <p>We look forward to welcoming you to the conference and an engaging experience ahead.</p>

        <p>Best regards,</p>
        <p><strong>Eco-Campus International Conference 2025 Team</strong></p>";


        $mail->Body = $mailBody;
        $mail->send();
        
        return true;
    } catch (Exception $e) {
        error_log("Email sending failed: " . $e->getMessage());
        return false;
    }
}

// Stripe Payment Processing
\Stripe\Stripe::setApiKey('sk_test_51ORZMGAea8RQqr9QjXKq5yeZijeh68frXazg3RuRKNPy4DFd3QmsWs8ZRzxQUHqBWkoKa9MTWVSihm5yHzaugUXO00IqkGkssO');

$session_id = $_GET['session_id'] ?? '';
$tran_ref = $_GET['txnRefNum'] ?? '';

if ($session_id && $tran_ref) {
    try {
        $session = \Stripe\Checkout\Session::retrieve($session_id);
        
        // Update payment status
        $stmt = $con->prepare("UPDATE wpcf_presto_reg_transaction SET `status` = ? WHERE donate_ref = ?");
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $con->error);
        }

        if ($session->payment_status === 'paid') {
            $status = 'success';
            $amount = $session->amount_total / 100;
            $customer_email = $session->customer_details->email ?? '';
          
            // Fetch transaction details
            $tran_ref_safe = mysqli_real_escape_string($con, $tran_ref);
            $select_sql = "SELECT * FROM wpcf_presto_reg_transaction WHERE donate_ref = '$tran_ref_safe'";
            $select_query = mysqli_query($con, $select_sql);
            
            if ($select_query && mysqli_num_rows($select_query) > 0) {
                $fetched_row = mysqli_fetch_assoc($select_query);
                $visaRequired = ($fetched_row['visaRequired'] ?? 'no') === 'yes';
                $passportNo = $fetched_row['passportNumber'] ?? '';
                $passportExpiry = $fetched_row['passportExpiry'] ?? '';
                $embassyLocation = $fetched_row['embassyLocation'] ?? '';
                $embassyName = $fetched_row['embassyName'] ?? '';
                $embassyAddress = $fetched_row['embassyAddress'] ?? '';
                $photoUrl = $fetched_row['photo_url'] ?? '';
                
                // Process photo if exists
                if (!empty($photoUrl) && strpos($photoUrl, 'photo/temp/') !== false) {
                    $tempPath = __DIR__ . '/../' . $photoUrl;
                    $newPath = str_replace('photo/temp/', 'photo/success/', $photoUrl);
                    $fullNewPath = __DIR__ . '/../' . $newPath;
                    
                    // Create directory if needed
                    $successDir = dirname($fullNewPath);
                    if (!file_exists($successDir)) {
                        mkdir($successDir, 0777, true);
                    }
                    
                    // Move the file
                    if (file_exists($tempPath) && is_readable($tempPath)) {
                        if (rename($tempPath, $fullNewPath)) {
                            $update_sql = "UPDATE wpcf_presto_reg_transaction SET photo_url = ? WHERE donate_ref = ?";
                            $photo_stmt = $con->prepare($update_sql);
                            $photo_stmt->bind_param("ss", $newPath, $tran_ref);
                            $photo_stmt->execute();
                        }
                    }
                }

                // Send confirmation email
                $recipientName = $fetched_row['firstname'] . ' ' . $fetched_row['lastname'];
                $recipientEmail = $fetched_row['email'];
                $registrationCategory = $fetched_row['registrationType'];
                $presentationType = $fetched_row['presentationType'] ?? '';
                $amountPaid = $fetched_row['amount'];
                $galaDinner = $fetched_row['galaDinner'] ?? 'No';
                
                sendRegistrationConfirmationEmail(
                    $recipientEmail, 
                    $recipientName, 
                    $registrationCategory, 
                    $presentationType, 
                    $amountPaid, 
                    $galaDinner, 
                    'Stripe', 
                    $tran_ref
                );
                
                if ($visaRequired) {
                    sendVisaInvitationEmail(
                        $fetched_row['email'], 
                        $fetched_row['firstname'] . ' ' . $fetched_row['lastname'],
                        $passportNo,
                        $passportExpiry,
                        $embassyLocation,
                        $embassyName,
                        $embassyAddress,
                        $fetched_row['registrationType'],
                        $fetched_row['presentationType'],
                        $tran_ref
                    );
                }
            }
        }

 
        $stmt->bind_param("ss", $status, $tran_ref);
        $stmt->execute();
        
        ob_end_clean();
        header("Location: https://icfe.greengrowthasia.org/payment-status/?txnRefNum=" . urlencode($tran_ref));
        exit;

    } catch (\Exception $e) {
        ob_end_clean();
        error_log("Stripe callback error: " . $e->getMessage());
        echo "<h1>⚠️ Error verifying payment</h1>";
        echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
    }
} else {
    ob_end_clean();
    echo "<h1>❌ Invalid session or transaction reference.</h1>";
}
?>