<?php

function generateSignature($data, $env="staging")
{
    $param = "";

    if(count($data) > 0)
    {
        ksort($data);
        reset($data);

        $last_key = (!empty($data)) ? array_keys($data)[count($data)-1] : null;
        
        foreach ($data as $key => $value)
        {  
            if($last_key == $key)
            {
                $param .=  $value;
            } else {
                $param .=  $value.":";
            }
        }
    }

    // echo "param = ".$param;
    if($env =='staging')
    {
        return sha256withrsaStaging($param);
    }
    
    return sha256withrsa($param);
}

function sha256withrsaStaging($data)
{
    $private_key = <<<EOD
    -----BEGIN PRIVATE KEY-----
    MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCSATZC6QMkGnuj
    ivg9pOYwxjHhrHpbwPl0KKIO+742P35UHzVRJfXIKf9SpRRmH2n7D3egfCDZmXJB
    uNeus8/ZYvcwGleZfVSunNLmInqUt2E5StVrqzJm6sUSQpo4qliku4HwnwQ/RG7Z
    yaWVaBexyjI3kH4I9MOZB5plHRdEKz7HBTnq/PpRTW2AwkHpn7aOiqrV3P0t3Yte
    y+TtSG3peEfO5+BkI1La/6fe0tNBrShTPai4Rpei8mDFfiLau7Zq40MHfT4uQqaI
    y/cuYFC7mumT1zZ+KdEMyOdx08PGaLESGXnWE57UGMBi41BbKgnrM7HOJPk23pt9
    KZ9UzIddAgMBAAECggEAW0RkrejIbN4dIXsyeB5HQn/yGHbfudFkXgc0XpdhLLn9
    9wnXI1XOUQRntTq6CKhkcGsXxXsycbNo58prEKsYJ3Skvi4JSko9EDW549/zrlj/
    bnfn9zj59bmV3TdC/l8FsFwB+u78EaxuereBSWbbQOj7AR7SmjieuF83VTOdIp/P
    y860s42Bfh4LF7udTb3LP0cQjVYuBpjXMKxs/r/Mt54xdv8tmy1m1wyrcvJ7fLbs
    V5aiiKhTvbqgM7x2GMUYQQqGODAOSMV4t6qIArEZ+7oVzR04mjRPCabhQux2udNk
    dG6m2VJUhy1ywwkym6ClR63IE9aIAwXLMFXSz2asZQKBgQDLEaHS5wT2WU0PU15Q
    7VeiCqHgM8j8XoIetw8L50sY88DxJdQLRwOKDiuVEIs9Jm/rJp4r/4Gf7wKEpNKM
    rqt1bNrmLgv0YjMu54WYh9SEZs/wamHwbOm7+AcfJHFmcNpBZwFEbI1eZV95YB71
    GsY0QKzMt1E0vqMYdFTR51JPUwKBgQC4D86ktafpAC8m/pAO/zL/DlVvwJyyP/OD
    JFTPtIRstAJbPvkLuJD4ntB4kNcvIQeHbvSfM5fRClaxVsNbzKW40JK0x6gGpay8
    xG4IofPR5mx+DOzi408I1vSeN4oo9C9OlNKczqS9vTquPxNh9samSnr/mXngpIN8
    WOrhB3XojwKBgQDDAaisFouuYq1ctUuSXYnVI262FiTBLaS5CEQbwz5btOCo8xHA
    zq44akkx+dQsoffCErC8Qb5iLqz1Yi6LSMWAm0tO1hNG2PKb7Vte0bmkd/LhxddN
    gdmnV5THNEDuBhuhyN/vrGrJpoHb1hGEgPSrgxwt7zC9fQC0YCp/9CsX3wKBgCZQ
    VAmBLsSXnzkUwFP+11S0XSB4DaYlHcFsrKLXxsEB74Oi5iCEeNjn5ilSrRhIXdLZ
    S95f1PhUmJstnljbjpub/w3Wialojz5z/Rua6rAEsQzEEANioa8LX7wXf5Dq03Ye
    EIFHmo9MdoyS4KwBvHQdCOFvxyj11dDqiWnyLZ8NAoGAT7HLY5M7J+wY67n5kR79
    HBurwDbQx5xiiUThJjtTkqykjQPX4ywyHgHO8s+lhsXcZfpX0kM12QVVSNsoShO1
    oxp2eXc+nWmXrCBCizGIJqVOFdmdBv9u9Fcb+HYN11Q8y6OTjYrtPw8hq9LYQXAg
    rWobqh0s8nrumd+fpGlj+rs=
    -----END PRIVATE KEY-----
    EOD;


    $binary_signature = "";
    $algo = OPENSSL_ALGO_SHA256;
    openssl_sign($data, $binary_signature, $private_key, $algo);
    $signature = base64_encode($binary_signature);
 
    return $signature;
}

function sha256withrsa($data)
{
    // $staging_private_key = <<<EOD
    // -----BEGIN RSA PRIVATE KEY-----
    // MIIEowIBAAKCAQEAkgE2QukDJBp7o4r4PaTmMMYx4ax6W8D5dCiiDvu+Nj9+VB81
    // USX1yCn/UqUUZh9p+w93oHwg2ZlyQbjXrrPP2WL3MBpXmX1UrpzS5iJ6lLdhOUrV
    // a6syZurFEkKaOKpYpLuB8J8EP0Ru2cmllWgXscoyN5B+CPTDmQeaZR0XRCs+xwU5
    // 6vz6UU1tgMJB6Z+2joqq1dz9Ld2LXsvk7Uht6XhHzufgZCNS2v+n3tLTQa0oUz2o
    // uEaXovJgxX4i2ru2auNDB30+LkKmiMv3LmBQu5rpk9c2finRDMjncdPDxmixEhl5
    // 1hOe1BjAYuNQWyoJ6zOxziT5Nt6bfSmfVMyHXQIDAQABAoIBAFtEZK3oyGzeHSF7
    // MngeR0J/8hh237nRZF4HNF6XYSy5/fcJ1yNVzlEEZ7U6ugioZHBrF8V7MnGzaOfK
    // axCrGCd0pL4uCUpKPRA1uePf865Y/2535/c4+fW5ld03Qv5fBbBcAfru/BGsbnq3
    // gUlm20Do+wEe0po4nrhfN1UznSKfz8vOtLONgX4eCxe7nU29yz9HEI1WLgaY1zCs
    // bP6/zLeeMXb/LZstZtcMq3Lye3y27FeWooioU726oDO8dhjFGEEKhjgwDkjFeLeq
    // iAKxGfu6Fc0dOJo0Twmm4ULsdrnTZHRuptlSVIctcsMJMpugpUetyBPWiAMFyzBV
    // 0s9mrGUCgYEAyxGh0ucE9llND1NeUO1Xogqh4DPI/F6CHrcPC+dLGPPA8SXUC0cD
    // ig4rlRCLPSZv6yaeK/+Bn+8ChKTSjK6rdWza5i4L9GIzLueFmIfUhGbP8Gph8Gzp
    // u/gHHyRxZnDaQWcBRGyNXmVfeWAe9RrGNECszLdRNL6jGHRU0edST1MCgYEAuA/O
    // pLWn6QAvJv6QDv8y/w5Vb8Ccsj/zgyRUz7SEbLQCWz75C7iQ+J7QeJDXLyEHh270
    // nzOX0QpWsVbDW8yluNCStMeoBqWsvMRuCKHz0eZsfgzs4uNPCNb0njeKKPQvTpTS
    // nM6kvb06rj8TYfbGpkp6/5l54KSDfFjq4Qd16I8CgYEAwwGorBaLrmKtXLVLkl2J
    // 1SNuthYkwS2kuQhEG8M+W7TgqPMRwM6uOGpJMfnULKH3whKwvEG+Yi6s9WIui0jF
    // gJtLTtYTRtjym+1bXtG5pHfy4cXXTYHZp1eUxzRA7gYbocjf76xqyaaB29YRhID0
    // q4McLe8wvX0AtGAqf/QrF98CgYAmUFQJgS7El585FMBT/tdUtF0geA2mJR3BbKyi
    // 18bBAe+DouYghHjY5+YpUq0YSF3S2UveX9T4VJibLZ5Y246bm/8N1ompaI8+c/0b
    // muqwBLEMxBADYqGvC1+8F3+Q6tN2HhCBR5qPTHaMkuCsAbx0HQjhb8co9dXQ6olp
    // 8i2fDQKBgE+xy2OTOyfsGOu5+ZEe/Rwbq8A20MecYolE4SY7U5KspI0D1+MsMh4B
    // zvLPpYbF3GX6V9JDNdkFVUjbKEoTtaMadnl3Pp1pl6wgQosxiCalThXZnQb/bvRX
    // G/h2DddUPMujk42K7T8PIavS2EFwIK1qG6odLPJ67pnfn6RpY/q7
    // -----END RSA PRIVATE KEY-----
    // EOD;

    $private_key = <<<EOD
    -----BEGIN PRIVATE KEY-----
    MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCfaGpMamgiBXAS
    wkaBn+RhLsqpEuCwmYsoP0FKeAyGEk3XDlEa8/VVJJxz3JiEnBA/7IuWpSLtONtg
    SRiMnmoW0xr9XQ8l9vAnH0KKOolGzc/av/KqCf3MfNuHWnkm+og6V4EfsTIFAr63
    KCc4AmlvsuRsSl4df41940liNIigQEl1QzkWXPc9WQbnH/h6vzGRM+DvAEjWNlNL
    FMOPRq3XomZ7LzD0nBjsWaGf56MVIWKN8XvrvMLNOxk0Czb6lpUcWM6/NoPd5ema
    WZmLpKNYubIyujBjhk4Ao3gBHdMnI8ul/Psvt73c85T/p2N8LRTgV+HjskMtkcxk
    tiuW/8QVAgMBAAECggEAOMSrjlkainsbRWLwTvtNDprmSz3QzLNxjjywmL+V3i0o
    kVyk349foBmwqcY2fotBcjJgJ57ZiFeGMIz3dCR6LXSymOYKHgAJ2DTWsnlUJ+Xl
    jsZqucljG+6fE13R5WK1HunIryugX45xsrJW/ShGuiOgGzyEtcaV8e3+VT3WJhMO
    8w4GQfEv0YsBW4T+3iWXuXN/7cYl809e4pLazrJ50Tvt4izBKzJTOkkPtXVwioJL
    5vrAXHk/tY8KkhBKsmaOI/IWDgvokjr9onIOIY/Td7b/erk7k29654VseTuMRhPR
    C1BRbqgdNhGb2YEee9K8S+YhfbQEmYJvdMK9wIKXAQKBgQDLi/9delezcmeOd5/c
    Ilg5+eL3swt2yYKqdTF2rrm9amFsTatu/PWDcEI2Hm5K9Td9/PcIAVrmDdVbteLG
    a1Mel65NJGkdn/G+BC2IYMpKhNMaB9PUDJLaHo9M2fNyEgiEY44wChWcQNY2Islw
    agK9ikEskWqMSRjNlJTemNgUQQKBgQDIfJCdJIhukuquj4Z9hBuRvBHm/lra39uj
    dh9ZoLWP0/qk7WrMy0mhRPsyhz3v+g/tkZMOtxuKHz7HGay0JD0P7s7sLP6TmKjI
    jkn7yFIrYNKE+azZIoqnQsPM7JH2cr7z80c4lShhI48bSHAhXulT9j/6vpohYeZr
    jiD87dRq1QKBgH2lesoyRkbgPSqFj2mszbdkGIX8wPvfokgktZbkfoV9UIwxWbzW
    a5tqRYTwvfaJbmrYJ4mKhJj0Oxs0qLsA7zs4OIEoE7cUz34TSCQiU10yprkv0cPY
    yyHXsW+oLo3gsd8/MTtYTkS5BUI/sQcyeWSVHmwri5DzYlss98R8pw3BAoGAfnrf
    PNPsYl27Qk73mL28Ks+MN78lkEmDpfcCRif2AvvHdz70jqh9FgmPs8vQTlHitIyP
    SsxHynZ1w2O2KZtnDmMpFaQ5IuI/MO9bS0WQWR9nEE73NbDt6iFbpy9j0ieHwh0r
    RE4NQGMPiDXFz7ex2a9To5uVXxQFKrtqokZkKNUCgYEArf5UEEFYhMdHysUWKpXH
    vEqKjVlpmm1ZqriE+iZKl+kQ7B8TZ0I1zasnWbaKMRDvBub9KhS3e7B4H+dCEgG3
    wRhgI7Um95gHneWtICRoVmX9BnefL+6SxDKqQqe7Pbn36MkhAuJwqmJm9TNQIDB7
    hGyxwNfhz0j3CXMqs6pXEN8=
    -----END PRIVATE KEY-----
    EOD;

    $binary_signature = "";
    $algo = OPENSSL_ALGO_SHA256;
    openssl_sign($data, $binary_signature, $private_key, $algo);
    $signature = base64_encode($binary_signature);
 
    return $signature;
}
function getRandomStringSha1($length = 8)
{
    $string = sha1(rand());
    $randomString = substr($string, 0, $length);
    return $randomString;
}

?>