<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly


function cf7rzp_get_payment_more_info($post_id){

    $res = [];
    $post_id = sanitize_text_field(is_numeric($_GET['post_id'])?$_GET['post_id']:exit);

    $post = get_post($post_id);
    $status = $post->post_status;
    
    $post_meta = get_post_meta($post_id);
    $order_id = $post_meta['cf7rzp_order_id'][0];
    $item_id = $post_meta['item_id'][0];
    $item_name = $post_meta['item_name'][0];
    $item_price = $post_meta['item_price'][0];
    $form_id = $post_meta['cf7_id'][0];
    $gateway = $post_meta['gateway'][0];
    $mode = $post_meta['mode'][0];
    $rzp_order_id = $post_meta['rzp_order_id'][0];
    $rzp_payment_id = $post_meta['rzp_payment_id'][0];
    $failure_reason = $post_meta['failure_reason'][0];

    $res['order_id'] = $order_id;
    $res['item_id'] = $item_id;
    $res['item_name'] = $item_name;
    $res['item_price'] = $item_price;
    $res['form_name'] = get_the_title($form_id);
    $res['gateway'] = $gateway;
    $res['mode'] = $mode;
    $res['rzp_order_id'] = $rzp_order_id;
    $res['status'] = $status;
    $res['status_label'] = cf7rzp_get_payment_status_label($status);

    $dt = get_the_date( 'Y-m-d H:i:s', $post_id);
    $dt = new DateTime($dt, new DateTimeZone('UTC'));
    $dt->setTimezone(new DateTimeZone('Asia/Kolkata'));
    $res['created_at'] = $dt->format('F j, Y | h:i:s a');



    if($status == "cf7rzp_success")
        $res['rzp_payment_id'] = $rzp_payment_id;

    if($status == "cf7rzp_failure")
        $res['failure_reason'] = $failure_reason;

    echo json_encode($res);
    wp_die();
}
add_action( 'wp_ajax_nopriv_cf7rzp_get_payment_more_info', 'cf7rzp_get_payment_more_info' );
add_action( 'wp_ajax_cf7rzp_get_payment_more_info', 'cf7rzp_get_payment_more_info' );

if ( !is_plugin_active( 'integrate-razorpay-contact-form-7-premium-addon/integrate-razorpay-contact-form-7-premium-addon.php' ) ) {
    add_filter( 'plugin_action_links_' . CF7RZP_DIR_NAME.'/integrate-razorpay-for-contact-form-7.php', 'cf7rzp_plugin_action_links' );
    add_filter('cf7rzp_admin_rzp_tab', 'cf7rzppa_admin_rzp_tabdemo');
    add_action( 'admin_menu', 'cf7rzppa_admin_menu', 20 );
}
function cf7rzp_plugin_action_links( $links ) {
    $settings_link = '<a href="/wp-admin/admin.php?page=cf7rzp_settings">Settings</a>';
	$premium_link = '<a href="https://cf7rzppa.codolin.com?utm_source=plugin_user&utm_medium=plugin&utm_campaign=upsell" target="_blank" style="font-weight: bold; color: #6f00d1;font-size:14px;">Get Pro</a>';
	array_push( $links, $settings_link, $premium_link );

	return $links;
}
function cf7rzppa_admin_rzp_tabdemo($rzp_tab_output) { 

    $rzp_tab_output_style = "<style>
                            .cf7rzppa-demo-rzp-settings{
                                opacity:0.7 !important;position:relative;
                            }
                            .premium-link{
                                position: absolute;
                                display: flex;
                                top: 0;
                                justify-content: center;
                                align-items: center;
                                width: 100%;
                                height: 100%;
                                z-index: 999;
                                background: radial-gradient(#ffffffcf 20%, #ffffff00 50%);
                            }
                            .premium-link a{
                                align-items: center;
                                background-color: #fec228;
                                border-radius: 4px;
                                box-shadow: inset 0 -4px 0 #0003;
                                box-sizing: border-box;
                                color: #000;
                                display: inline-flex;
                                filter: drop-shadow(0 2px 4px rgba(0,0,0,.2));
                                font-family: Arial,sans-serif;
                                font-size: 16px;
                                justify-content: center;
                                line-height: 1.5;
                                min-height: 48px;
                                padding: 8px 1em;
                                text-decoration: none;
                            }
                            .premium-link a:hover{
                                background-color: #f2ae01;
                                color: #000;
                            }
                        </style>";

    $rzp_tab_output .=  $rzp_tab_output_style; 

    $rzp_tab_output .= "<tbody class='cf7rzppa-demo-rzp-settings'>
                            <tr><td>&nbsp;</td></tr>
                            <tr class='premium-link'><td><a href='https://cf7rzppa.codolin.com?utm_source=plugin_user&utm_medium=plugin&utm_campaign=upsell' target='_blank'>Unlock with Premium</a></td></tr>"; 

    $rzp_tab_output .= "<tr><td style='background: #e4e4e4;text-align: center;' colspan='3'><h2 style='color:green;font-weight:bold;'>Premium Settings</h2></td></tr>"; 

    $rzp_tab_output .= "<tr><td>&nbsp;</td></tr>"; 
    
    $rzp_tab_output .= "<td><label><b>Pre-defined Pricing Options: </b></label></td>";
	$rzp_tab_output .= "<td><input name='' value='1' class='cf7rzppa_price_enable_checkbox' type='checkbox' CHECKED></td>
                        <td>[ Enabling will override the Item price ]</td>
                        </tr>&nbsp;";

    $rzp_tab_output .= "<tr><td>&nbsp;</td></tr>";

    $rzp_tab_output .= "<tr>
                            <td>Pre-defined Pricing Form Field: </td>
	                        <td><input type='text' name='' value='variable-price'> <br/>Example: variable-price</td>
                            <td>[ The Form field in contact form 7 that should be used for pre-defined pricing. Allowed form fields: radio buttons | drop-down menu(single select) | checkboxes(single select) ]</td>
                        </tr>";

    $rzp_tab_output .= "<tr><td>&nbsp;</td></tr>";

    $rzp_tab_output .= "<tr>
                            <td>Pre-defined Pricing Value: </td>
	                        <td><input type='text' name='' value='100|200|300'> <br/>Example: 100|200|300</td>
                            <td>[ Enter pre-defined price value seperated by pipline'|' symbol. <span>Price mapping to options is based on order it is entered.</span> ]</td>
                        </tr>";

    $rzp_tab_output .= "<tr><td>&nbsp;</td></tr>";

    $end_user_pricing_html = "
                            <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                            <tr>
                                <td><b>User-defined Pricing: </b></td>
                                <td><input name='' value='1' class='cf7rzppa_price_enable_checkbox' type='checkbox'></td>
                                <td>[ Enabling will override the Item price ]</td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            <tr>
                                <td>User-defined Pricing Form Field: </td>
                                <td><input type='text' name='' value='enduser-price'> <br/>Example: enduser-price</td>
                                <td>[ The Form field in contact form 7 that should be used for user-defined pricing. Allowed form fields: number | text ]</td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            ";
    $rzp_tab_output .=  $end_user_pricing_html;     
    
    $form_data_collection_html = "
                            <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                            <tr>
                                <td><b>Enable FormData Collection: </b></td>
                                <td><input name='' value='1' type='checkbox' CHECKED></td>
                                <td>[ Enabling will collect user submitted form data ]</td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            "; 
    $rzp_tab_output .=  $form_data_collection_html; 

    $order_shortcode_html = "
                            <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                            <tr>
                                <td><b>Enable Order Shortcode: </b></td>
                                <td><input name='' value='1' type='checkbox' CHECKED></td>
                                <td>[ Enabling will allow to use order related shortcodes in \"Thank You Page\" ]</td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            <tr>
                                <td><b>[cf7rzppa-order]</b></td>
                                <td><b>Shortcode Usage in \"Thank You\" Page:</b></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td colspan='3'>
                                    <ul style='list-style-type:square;padding-left:17px;'>
                                        <li><code>[cf7rzppa-order]</code> - By default display \"Order Id\" if no \"data\" attribute passed.</li>
                                        <li><code>[cf7rzppa-order data=\"order_id\"]</code> - Display \"Order Id\"</li>
                                        <li><code>[cf7rzppa-order data=\"item_id\"]</code> - Display order related \"Item Id\"</li>
                                        <li><code>[cf7rzppa-order data=\"item_name\"]</code> - Display order related \"Item Name\"</li>
                                        <li><code>[cf7rzppa-order data=\"item_price\"]</code> - Display order related \"Item Price\"</li>
                                    </ul>
                                </td>
                                <td></td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            ";
    $rzp_tab_output .=  $order_shortcode_html;   

    $export_csv_html = "
                        <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Enable \"Export CSV\": </b></td>
                            <td><input name='' value='1' type='checkbox' CHECKED></td>
                            <td>[ Enabling will allow \"export/download\" of \"Order/Payment\" data and its associated \"User submitted form\" data as CSV file wrt this contact form. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        ";
    $rzp_tab_output .=  $export_csv_html;  

    $custom_orderid_prefix_html = "
                        <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Custom OrderId Prefix: </b></td>
                            <td><input name='' value='1' type='checkbox'></td>
                            <td>[ Enabling will override the default OrderId prefix. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>OrderId Prefix: </td>
                            <td><input type='text' name='' value=''> <br/>Example: YOURPRODUCTCODE_</td>
                            <td>[ Enter your custom OrderId Prefix that should replace default prefix: \"cf7rzp_\" ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        ";
    $rzp_tab_output .=  $custom_orderid_prefix_html;

    $order_success_redirect_html = "
                        <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Order Success Redirect: </b></td>
                            <td><input name='' value='1' type='checkbox'></td>
                            <td>[ Enabling will override the default Return/Success Url. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Order Success Redirect Url: </td>
                            <td><input type='text' name='' value=''> <br/>Example: http://example.com/thankyou.</td>
                            <td>[ If the customer makes succesful Razorpay Payment, where are they redirected to after.
                            It can be either Internal Thank You page url or External url. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        ";
    $rzp_tab_output .=  $order_success_redirect_html;

    $rzp_payment_popup_settings_html = "
                        <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                        <tr>
                            <td></td>
                            <td colspan='3' style='font-size:14px;text-decoration:underline;'><b>Razorpay Payment Popup Settings:</b></td>
                            <td></td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td><b>Enable Logo: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will override the Global settings. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Logo (URL): </td>
                            <td><input type='text' name='' value=''> <br/> </td>
                            <td>[ This will be displayed in Razorpay Payment Popup. Choose a square image of minimum dimensions 256x256 px. ]</td>
                        </tr>
                        <tr>
                            <td></td>
                            <td colspan='3'><br/>Example: https://cdn.razorpay.com/logos/FFATTsJeURNMxx_medium.png</td>
                            <td></td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr><td colspan='3' style='border-top:1px dashed;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Enable Theme Color: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will override the Global settings. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Theme Color: </td>
                            <td><input type='text' name='' value=''> <br/>Example: #cccccc </td>
                            <td>[ Enter a HEX color code to change the Razorpay Payment Popup Theme color. <a href=\"https://htmlcolorcodes.com/\" target=\"_blank\">HEX Color Picker</a> ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr><td colspan='3' style='border-top:1px dashed;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Enable Theme Backdrop Color: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will override the Global settings. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Theme Backdrop Color: </td>
                            <td><input type='text' name='' value=''> <br/>Example: #000000 </td>
                            <td>[ Enter a HEX color code to change the Razorpay Payment Popup Theme backdrop color. <a href=\"https://htmlcolorcodes.com/\" target=\"_blank\">HEX Color Picker</a> ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        ";
    $rzp_tab_output .=  $rzp_payment_popup_settings_html;

    $autofill_customer_info_html = "
                        <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                        <tr>
                            <td colspan='3' style='text-align:center;font-size:14px;text-decoration:underline;'><b>Autofill Customer Information In Razorpay Payment Popup:</b></td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td><b>Autofill Customer Name: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will autofill customer name. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Customer Name Form Field: </td>
                            <td><input type='text' name='' value=''> <br/> Example: your-name </td>
                            <td>[ The Form field in contact form 7 that should be used for autofilling customer name in Razorpay Payment Popup. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr><td colspan='3' style='border-top:1px dashed;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Autofill Customer Email: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will autofill customer email. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Customer Email Form Field: </td>
                            <td><input type='text' name='' value=''> <br/>Example: your-email </td>
                            <td>[  The Form field in contact form 7 that should be used for autofilling customer email in Razorpay Payment Popup. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr><td colspan='3' style='border-top:1px dashed;'>&nbsp;</td></tr>
                        <tr>
                            <td><b>Autofill Customer Phone: </b></td>
                            <td><input name='' value='' type='checkbox'></td>
                            <td>[ Enabling will autofill customer phone. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        <tr>
                            <td>Customer Phone Form Field: </td>
                            <td><input type='text' name='' value=''> <br/>Example: your-phone</td>
                            <td>[  The Form field in contact form 7 that should be used for autofilling customer phone in Razorpay Payment Popup. ]</td>
                        </tr>
                        <tr><td>&nbsp;</td></tr>
                        ";
    $rzp_tab_output .=  $autofill_customer_info_html;

    $email_notify_html = "
                            <tr><td colspan='3' style='border-top:1px solid;'>&nbsp;</td></tr>
                            <tr>
                                <td><b>Enable Email Notification: </b></td>
                                <td><input name='' value='' type='checkbox'></td>
                                <td>[  Enabling this option will stop the default email from being sent after form submission. Instead, it allows the use of <b>CF7RZP Mail Tags</b> in the \"Mail\" Tab's \"Message Body\" settings and sends an email notification only after a successful payment, including order details based on the configured mail tags. ]</td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            <tr>
                                <td></td>
                                <td><b>Available CF7RZP Mail Tags:</b></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td colspan='3'>
                                    <ul style='list-style-type:square;padding-left:17px;'>
                                        <li><code>[cf7rzppa-order-id]</code> - Display \"Order Id\"</li>
                                        <li><code>[cf7rzppa-order-item-id]</code> - Display order related \"Item Id\"</li>
                                        <li><code>[cf7rzppa-order-item-name]</code> - Display order related \"Item Name\"</li>
                                        <li><code>[cf7rzppa-order-item-price]</code> - Display order related \"Item Price\"</li>
                                    </ul>
                                </td>
                                <td></td>
                            </tr>
                            <tr><td>&nbsp;</td></tr>
                            ";

    $rzp_tab_output .=  $email_notify_html;

    $rzp_tab_output .= '</tbody></table>';

    return $rzp_tab_output;   
}

function cf7rzppa_admin_menu() {
	add_submenu_page(
        'wpcf7',
        'CF7RZP Premium',
        'CF7RZP Premium',
        'manage_options', 
        'cf7rzp-get-premium',
        'get_premium',
        5
    );
}

add_action('cf7rzp_admin_demo_rzp_settings_in', 'cf7rzppa_admin_demo_rzp_settings_in');
function cf7rzppa_admin_demo_rzp_settings_in($options) {  
    include_once('demo_rzp_settings_in.php');
}

