<?php
/**
 * Astra child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

function presto_payment_response() {
    global $wpdb;

    $txnRefNum = $_GET['txnRefNum'] ?? '';

    if ($txnRefNum) {
        $table_name = $wpdb->prefix . "presto_reg_transaction";
        $transaction = $wpdb->get_row("SELECT * FROM $table_name WHERE donate_ref = '$txnRefNum'", ARRAY_A);

        if ($transaction) {
            $payment_response = json_decode($transaction['request_response'], true);
            $payment_status = $payment_response['paymentStatus'] ?? 'Unknown';

            ob_start(); 

            echo "<div class='payment-status-container'>";

            echo "<div class='payment-status'>";
            echo "<h2 class='transaction-title'>Transaction ID: " . esc_html($txnRefNum) . "</h2>";

            $status = $transaction['status'] ?? 'Unknown';
            echo "<div class='status-message'>";

            if ($status === 'success') {
                echo "<div class='status success'>🎉 Payment Successful!</div>";
            } elseif ($status === 'failed') {
                echo "<div class='status failed'>❌ Payment Failed!</div>";
            } elseif ($status === 'pending') {
                echo "<div class='status pending'>⏳ Payment Pending!</div>";
            } else {
                echo "<div class='status unknown'>❓ Unknown Payment Status!</div>";
            }

            echo "</div></div>";  

            echo "<div class='registrant-details'>";
            echo "<h3>Registrant Details:</h3>";
            echo "<p><strong>First Name:</strong> " . esc_html($transaction['firstname']) . "</p>";
            echo "<p><strong>Last Name:</strong> " . esc_html($transaction['lastname']) . "</p>";
            echo "<p><strong>Email:</strong> " . esc_html($transaction['email']) . "</p>";
            echo "<p><strong>Phone:</strong> " . esc_html($transaction['phone']) . "</p>";
            echo "<p><strong>Registration Type:</strong> " . esc_html($transaction['registrationType']) . "</p>";
            echo "<p><strong>Gala Dinner:</strong> " . esc_html($transaction['galaDinner']) . "</p>";
            echo "</div>";  

            // ✅ Move confirmation message here, outside status section
            if ($status === 'success') {
                echo "<div class='confirmation-message'>";
                echo "<p>Thank you for your registration! A confirmation email has been sent to your provided email address. Please check your inbox (and spam folder) for important information regarding your registration, including any additional details.</p>";
                echo "<p>If you do not receive the confirmation email within 24 hours, please contact us at <a href='mailto:adilah.a@greengrowthasia.org'>adilah.a@greengrowthasia.org</a> or <a href='mailto:jessica@fee.global'>jessica@fee.global</a>.</p>";
                echo "</div>";
            }

            echo "</div>"; // Close .payment-status-container

            return ob_get_clean(); 
        } else {
            return "<div class='error-message'>⚠ Transaction Not Found!</div>";
        }
    } else {
        return "<div class='error-message'>No Payment Data Received</div>";
    }
}

add_shortcode('presto_payment_status', 'presto_payment_response');

function enqueue_custom_form_script() {
    // Only enqueue this script on specific pages if needed
    // Replace 'page-slug' with your actual page slug or condition
    if (is_page('abstract-submission')) { 
        ?>
        <script>
        document.addEventListener('DOMContentLoaded', function () {
          const attendRadios = document.querySelectorAll('input[name="attend-the-conference"]');
          const presentationWrapper = document.getElementById('presentation-field-wrapper');

          function togglePresentationField() {
            let selected = Array.from(attendRadios).find(r => r.checked);
            if (selected && selected.value === "Yes") {
              presentationWrapper.style.display = 'block';
            } else {
              presentationWrapper.style.display = 'none';
              const presentationRadios = document.querySelectorAll('input[name="presentation"]');
              presentationRadios.forEach(r => r.checked = false);
            }
          }

          attendRadios.forEach(radio => {
            radio.addEventListener('change', togglePresentationField);
          });

          togglePresentationField();
        });
        </script>
        <?php
    }
}
add_action('wp_footer', 'enqueue_custom_form_script');

function custom_attendance_toggle_script() {
    ?>
    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            const attendConferenceRadios = document.querySelectorAll('input[name="attend-the-conference"]');
            const presentationField = document.getElementById('presentation-field');
            
            function togglePresentationField() {
                const selected = document.querySelector('input[name="attend-the-conference"]:checked');
                if (selected) {
                    presentationField.style.display = (selected.value === 'Yes') ? 'block' : 'none';
                }
            }

            attendConferenceRadios.forEach(radio => {
                radio.addEventListener('change', togglePresentationField);
            });

            // Initial check
            togglePresentationField();
        });
    </script>
    <?php
}
add_action('wp_footer', 'custom_attendance_toggle_script');


